/* masterclock.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */

// Imports ===================================================================
use crate::hal::generic::timer::TimerControl;
use crate::hal::generic::timer::TimerMode::Periodic;
use crate::event::OxideEventQueue;

use crate::deviceconsts::my::{ MASTER_CLOCK_PRESCALER, MASTER_CLOCK_HZ, MASTER_TICK_PERIOD_CS };

// Declarations ==============================================================


pub struct MasterClock<T>
where
  T: 'static + TimerControl
{
  timer: &'static mut T,
  eventq: &'static OxideEventQueue
}


// Code ======================================================================

impl<T> MasterClock<T>
where
  T: TimerControl
{
  pub fn new(timer: &'static mut T, eventq: &'static OxideEventQueue) -> Self {
    const PERIPHERAL_CLOCK_HZ: u32  = MASTER_CLOCK_HZ/MASTER_CLOCK_PRESCALER as u32;
    const TIMER_CLOCK_HZ: u32       = PERIPHERAL_CLOCK_HZ/2; // We use CLK_PER/2 in timer config
    const CYCLES_PER_CS: u16        = (TIMER_CLOCK_HZ/100) as u16;

    Self {
      timer: timer.mode(Periodic).count_max(CYCLES_PER_CS).interrupting(MASTER_TICK_PERIOD_CS),
      eventq
    }
  }

  pub fn run(&mut self) {
    self.timer.start(Some(|_ticks:u16| {
      //let mut led = Hardware::borrow().led_mut(LedFunction::WHITE);
      //led.toggle();
      true
    }));
  }
}


// Tests =====================================================================
