/* button.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! @todo documentation for this module
//!
//!

// Imports ===================================================================
use crate::hal::generic::port::Pin;


// Declarations ==============================================================
#[derive(PartialEq,Eq,Clone,Copy)]
pub enum ButtonState {
  Pressed,
  Released,
  Unknown
}

pub struct Button<P>
where
  P: Pin
{
  pin: P,
  last_state: ButtonState
}

// Code ======================================================================
impl<P> Button<P>
where
  P: Pin
{
  pub fn using_pin(pin: P) -> Self {
    Button {
      pin,
      last_state: ButtonState::Unknown
    }
  }

  pub fn is_pressed(&self) -> bool {
    todo!()
  }

  pub fn state(&self) -> ButtonState {
    todo!()
  }
}
