/* deviceconsts.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! Device-specific constants

// Imports ===================================================================


// Declarations ==============================================================
#[cfg(not(any(feature="20MHz", feature="16MHz")))]
compile_error!("A clockspeed feature (\"16MHz\", \"20MHz\") must be enabled for this crate");

#[cfg(all(feature="20MHz", feature="16MHz"))]
compile_error!("Only one clockspeed feature (\"16MHz\", \"20MHz\") may be enabled for this crate");

#[cfg(not(any(feature="atmega4809")))]
compile_error!("A processor feature (\"atmega4809\") must be enabled for this crate");


#[cfg(all(feature = "atmega4809", feature = "20MHz"))]
pub mod my {
  pub const MASTER_CLOCK_HZ: u32         = 20_000_000; // Config'd in device fuses
  pub const MASTER_CLOCK_PRESCALER:  u8  = 6;          // Device default (per datasheet)
  pub const MASTER_TICK_PERIOD_CS: u16   = 5;          // Our desire - 20Hz
}

#[cfg(all(feature = "atmega4809", feature = "16MHz"))]
pub mod my {
  pub const MASTER_CLOCK_HZ: u32         = 16_000_000; // Config'd in device fuses
  pub const MASTER_CLOCK_PRESCALER:  u8  = 6;          // Device default (per datasheet)
  pub const MASTER_TICK_PERIOD_CS: u16   = 5;          // Our desire - 20Hz
}


// Code ======================================================================


// Tests =====================================================================
