/* arduino.rs
 *
 * Developed by Tim Walls <tim.walls@snowgoons.com>
 * Copyright (c) All Rights Reserved, Tim Walls
 */
//! A helper module that maps standard ATmega pins into equivalent Arduino
//! names.


// Imports ===================================================================

// Declarations ==============================================================
#[cfg(feature="atmega4809")]
pub mod nanoevery {
  use crate::hal::atmega4809::hardware::Hardware;
  use crate::hal::atmega4809;

  pub struct Arduino {
    pub a0: atmega4809::port::portd::PinImpl<3>,
    pub a1: atmega4809::port::portd::PinImpl<2>,
    pub a2: atmega4809::port::portd::PinImpl<1>,
    pub a3: atmega4809::port::portd::PinImpl<0>,
    pub a4: atmega4809::port::porta::PinImpl<2>,
    pub a5: atmega4809::port::porta::PinImpl<3>,
    pub a6: atmega4809::port::portd::PinImpl<4>,
    pub a7: atmega4809::port::portd::PinImpl<5>,

    pub d0: atmega4809::port::portc::PinImpl<4>,
    pub d1: atmega4809::port::portc::PinImpl<5>,
    pub d2: atmega4809::port::porta::PinImpl<0>,
    pub d3: atmega4809::port::portf::PinImpl<5>,
    pub d4: atmega4809::port::portc::PinImpl<6>,
    pub d5: atmega4809::port::portb::PinImpl<2>,
    pub d6: atmega4809::port::portf::PinImpl<4>,
    pub d7: atmega4809::port::porta::PinImpl<1>,
    pub d8: atmega4809::port::porte::PinImpl<3>,
    pub d9: atmega4809::port::portb::PinImpl<0>,
    pub d10: atmega4809::port::portb::PinImpl<1>,
    pub d11: atmega4809::port::porte::PinImpl<0>,
    pub d12: atmega4809::port::porte::PinImpl<1>,
    pub d13: atmega4809::port::porte::PinImpl<2>,
  }


  impl From<&'static mut crate::hal::atmega4809::hardware::Hardware> for Arduino {
    fn from(_avr: &'static mut Hardware) -> Self {
      Arduino {
        a0: atmega4809::port::portd::pin_instance(),
        a1: atmega4809::port::portd::pin_instance(),
        a2: atmega4809::port::portd::pin_instance(),
        a3: atmega4809::port::portd::pin_instance(),
        a4: atmega4809::port::porta::pin_instance(),
        a5: atmega4809::port::porta::pin_instance(),
        a6: atmega4809::port::portd::pin_instance(),
        a7: atmega4809::port::portd::pin_instance(),
        d0: atmega4809::port::portc::pin_instance(),
        d1: atmega4809::port::portc::pin_instance(),
        d2: atmega4809::port::porta::pin_instance(),
        d3: atmega4809::port::portf::pin_instance(),
        d4: atmega4809::port::portc::pin_instance(),
        d5: atmega4809::port::portb::pin_instance(),
        d6: atmega4809::port::portf::pin_instance(),
        d7: atmega4809::port::porta::pin_instance(),
        d8: atmega4809::port::porte::pin_instance(),
        d9: atmega4809::port::portb::pin_instance(),
        d10: atmega4809::port::portb::pin_instance(),
        d11: atmega4809::port::porte::pin_instance(),
        d12: atmega4809::port::porte::pin_instance(),
        d13: atmega4809::port::porte::pin_instance(),
      }
    }
  }
}

// Tests =====================================================================
