#[doc = "Register `USISR` reader"]
pub struct R(crate::R<USISR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<USISR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<USISR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<USISR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `USISR` writer"]
pub struct W(crate::W<USISR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<USISR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<USISR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<USISR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `USICNT` reader - USI Counter Value Bits"]
pub struct USICNT_R(crate::FieldReader<u8, u8>);
impl USICNT_R {
    pub(crate) fn new(bits: u8) -> Self {
        USICNT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for USICNT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `USICNT` writer - USI Counter Value Bits"]
pub struct USICNT_W<'a> {
    w: &'a mut W,
}
impl<'a> USICNT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u8 & 0x0f);
        self.w
    }
}
#[doc = "Field `USIDC` reader - Data Output Collision"]
pub struct USIDC_R(crate::FieldReader<bool, bool>);
impl USIDC_R {
    pub(crate) fn new(bits: bool) -> Self {
        USIDC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for USIDC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `USIPF` reader - Stop Condition Flag"]
pub struct USIPF_R(crate::FieldReader<bool, bool>);
impl USIPF_R {
    pub(crate) fn new(bits: bool) -> Self {
        USIPF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for USIPF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `USIPF` writer - Stop Condition Flag"]
pub struct USIPF_W<'a> {
    w: &'a mut W,
}
impl<'a> USIPF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `USIOIF` reader - Counter Overflow Interrupt Flag"]
pub struct USIOIF_R(crate::FieldReader<bool, bool>);
impl USIOIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        USIOIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for USIOIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `USIOIF` writer - Counter Overflow Interrupt Flag"]
pub struct USIOIF_W<'a> {
    w: &'a mut W,
}
impl<'a> USIOIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `USISIF` reader - Start Condition Interrupt Flag"]
pub struct USISIF_R(crate::FieldReader<bool, bool>);
impl USISIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        USISIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for USISIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `USISIF` writer - Start Condition Interrupt Flag"]
pub struct USISIF_W<'a> {
    w: &'a mut W,
}
impl<'a> USISIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:3 - USI Counter Value Bits"]
    #[inline(always)]
    pub fn usicnt(&self) -> USICNT_R {
        USICNT_R::new((self.bits & 0x0f) as u8)
    }
    #[doc = "Bit 4 - Data Output Collision"]
    #[inline(always)]
    pub fn usidc(&self) -> USIDC_R {
        USIDC_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Stop Condition Flag"]
    #[inline(always)]
    pub fn usipf(&self) -> USIPF_R {
        USIPF_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Counter Overflow Interrupt Flag"]
    #[inline(always)]
    pub fn usioif(&self) -> USIOIF_R {
        USIOIF_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Start Condition Interrupt Flag"]
    #[inline(always)]
    pub fn usisif(&self) -> USISIF_R {
        USISIF_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:3 - USI Counter Value Bits"]
    #[inline(always)]
    pub fn usicnt(&mut self) -> USICNT_W {
        USICNT_W { w: self }
    }
    #[doc = "Bit 5 - Stop Condition Flag"]
    #[inline(always)]
    pub fn usipf(&mut self) -> USIPF_W {
        USIPF_W { w: self }
    }
    #[doc = "Bit 6 - Counter Overflow Interrupt Flag"]
    #[inline(always)]
    pub fn usioif(&mut self) -> USIOIF_W {
        USIOIF_W { w: self }
    }
    #[doc = "Bit 7 - Start Condition Interrupt Flag"]
    #[inline(always)]
    pub fn usisif(&mut self) -> USISIF_W {
        USISIF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USI Status Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [usisr](index.html) module"]
pub struct USISR_SPEC;
impl crate::RegisterSpec for USISR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [usisr::R](R) reader structure"]
impl crate::Readable for USISR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [usisr::W](W) writer structure"]
impl crate::Writable for USISR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets USISR to value 0"]
impl crate::Resettable for USISR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
