#[doc = "Register `TCCR1D` reader"]
pub struct R(crate::R<TCCR1D_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR1D_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR1D_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR1D_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR1D` writer"]
pub struct W(crate::W<TCCR1D_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR1D_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR1D_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR1D_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Waveform Generation Mode Bit\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum WGM1_A {
    #[doc = "0: Fast PWM, Update: *TOP*, Flag: *TOP*"]
    PWM_FAST = 0,
    #[doc = "1: Phase and Frequency Correct PWM, Update: *BOTTOM*, Flag: *BOTTOM*"]
    PWM_CORRECT = 1,
    #[doc = "2: PWM6 / Single-slope, Update: *TOP*, Flag: *TOP*"]
    PWM_SINGLE_SLOPE = 2,
    #[doc = "3: PWM6 / Dual-slope, Update: *BOTTOM*, Flag: *BOTTOM*"]
    PWM_DUAL_SLOPE = 3,
}
impl From<WGM1_A> for u8 {
    #[inline(always)]
    fn from(variant: WGM1_A) -> Self {
        variant as _
    }
}
#[doc = "Field `WGM1` reader - Waveform Generation Mode Bit"]
pub struct WGM1_R(crate::FieldReader<u8, WGM1_A>);
impl WGM1_R {
    pub(crate) fn new(bits: u8) -> Self {
        WGM1_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> WGM1_A {
        match self.bits {
            0 => WGM1_A::PWM_FAST,
            1 => WGM1_A::PWM_CORRECT,
            2 => WGM1_A::PWM_SINGLE_SLOPE,
            3 => WGM1_A::PWM_DUAL_SLOPE,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `PWM_FAST`"]
    #[inline(always)]
    pub fn is_pwm_fast(&self) -> bool {
        **self == WGM1_A::PWM_FAST
    }
    #[doc = "Checks if the value of the field is `PWM_CORRECT`"]
    #[inline(always)]
    pub fn is_pwm_correct(&self) -> bool {
        **self == WGM1_A::PWM_CORRECT
    }
    #[doc = "Checks if the value of the field is `PWM_SINGLE_SLOPE`"]
    #[inline(always)]
    pub fn is_pwm_single_slope(&self) -> bool {
        **self == WGM1_A::PWM_SINGLE_SLOPE
    }
    #[doc = "Checks if the value of the field is `PWM_DUAL_SLOPE`"]
    #[inline(always)]
    pub fn is_pwm_dual_slope(&self) -> bool {
        **self == WGM1_A::PWM_DUAL_SLOPE
    }
}
impl core::ops::Deref for WGM1_R {
    type Target = crate::FieldReader<u8, WGM1_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WGM1` writer - Waveform Generation Mode Bit"]
pub struct WGM1_W<'a> {
    w: &'a mut W,
}
impl<'a> WGM1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: WGM1_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Fast PWM, Update: *TOP*, Flag: *TOP*"]
    #[inline(always)]
    pub fn pwm_fast(self) -> &'a mut W {
        self.variant(WGM1_A::PWM_FAST)
    }
    #[doc = "Phase and Frequency Correct PWM, Update: *BOTTOM*, Flag: *BOTTOM*"]
    #[inline(always)]
    pub fn pwm_correct(self) -> &'a mut W {
        self.variant(WGM1_A::PWM_CORRECT)
    }
    #[doc = "PWM6 / Single-slope, Update: *TOP*, Flag: *TOP*"]
    #[inline(always)]
    pub fn pwm_single_slope(self) -> &'a mut W {
        self.variant(WGM1_A::PWM_SINGLE_SLOPE)
    }
    #[doc = "PWM6 / Dual-slope, Update: *BOTTOM*, Flag: *BOTTOM*"]
    #[inline(always)]
    pub fn pwm_dual_slope(self) -> &'a mut W {
        self.variant(WGM1_A::PWM_DUAL_SLOPE)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Field `FPF1` reader - Fault Protection Interrupt Flag"]
pub struct FPF1_R(crate::FieldReader<bool, bool>);
impl FPF1_R {
    pub(crate) fn new(bits: bool) -> Self {
        FPF1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FPF1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FPF1` writer - Fault Protection Interrupt Flag"]
pub struct FPF1_W<'a> {
    w: &'a mut W,
}
impl<'a> FPF1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `FPAC1` reader - Fault Protection Analog Comparator Enable"]
pub struct FPAC1_R(crate::FieldReader<bool, bool>);
impl FPAC1_R {
    pub(crate) fn new(bits: bool) -> Self {
        FPAC1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FPAC1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FPAC1` writer - Fault Protection Analog Comparator Enable"]
pub struct FPAC1_W<'a> {
    w: &'a mut W,
}
impl<'a> FPAC1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `FPES1` reader - Fault Protection Edge Select"]
pub struct FPES1_R(crate::FieldReader<bool, bool>);
impl FPES1_R {
    pub(crate) fn new(bits: bool) -> Self {
        FPES1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FPES1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FPES1` writer - Fault Protection Edge Select"]
pub struct FPES1_W<'a> {
    w: &'a mut W,
}
impl<'a> FPES1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `FPNC1` reader - Fault Protection Noise Canceler"]
pub struct FPNC1_R(crate::FieldReader<bool, bool>);
impl FPNC1_R {
    pub(crate) fn new(bits: bool) -> Self {
        FPNC1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FPNC1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FPNC1` writer - Fault Protection Noise Canceler"]
pub struct FPNC1_W<'a> {
    w: &'a mut W,
}
impl<'a> FPNC1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `FPEN1` reader - Fault Protection Mode Enable"]
pub struct FPEN1_R(crate::FieldReader<bool, bool>);
impl FPEN1_R {
    pub(crate) fn new(bits: bool) -> Self {
        FPEN1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FPEN1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FPEN1` writer - Fault Protection Mode Enable"]
pub struct FPEN1_W<'a> {
    w: &'a mut W,
}
impl<'a> FPEN1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `FPIE1` reader - Fault Protection Interrupt Enable"]
pub struct FPIE1_R(crate::FieldReader<bool, bool>);
impl FPIE1_R {
    pub(crate) fn new(bits: bool) -> Self {
        FPIE1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FPIE1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FPIE1` writer - Fault Protection Interrupt Enable"]
pub struct FPIE1_W<'a> {
    w: &'a mut W,
}
impl<'a> FPIE1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Waveform Generation Mode Bit"]
    #[inline(always)]
    pub fn wgm1(&self) -> WGM1_R {
        WGM1_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bit 2 - Fault Protection Interrupt Flag"]
    #[inline(always)]
    pub fn fpf1(&self) -> FPF1_R {
        FPF1_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Fault Protection Analog Comparator Enable"]
    #[inline(always)]
    pub fn fpac1(&self) -> FPAC1_R {
        FPAC1_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Fault Protection Edge Select"]
    #[inline(always)]
    pub fn fpes1(&self) -> FPES1_R {
        FPES1_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Fault Protection Noise Canceler"]
    #[inline(always)]
    pub fn fpnc1(&self) -> FPNC1_R {
        FPNC1_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Fault Protection Mode Enable"]
    #[inline(always)]
    pub fn fpen1(&self) -> FPEN1_R {
        FPEN1_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Fault Protection Interrupt Enable"]
    #[inline(always)]
    pub fn fpie1(&self) -> FPIE1_R {
        FPIE1_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - Waveform Generation Mode Bit"]
    #[inline(always)]
    pub fn wgm1(&mut self) -> WGM1_W {
        WGM1_W { w: self }
    }
    #[doc = "Bit 2 - Fault Protection Interrupt Flag"]
    #[inline(always)]
    pub fn fpf1(&mut self) -> FPF1_W {
        FPF1_W { w: self }
    }
    #[doc = "Bit 3 - Fault Protection Analog Comparator Enable"]
    #[inline(always)]
    pub fn fpac1(&mut self) -> FPAC1_W {
        FPAC1_W { w: self }
    }
    #[doc = "Bit 4 - Fault Protection Edge Select"]
    #[inline(always)]
    pub fn fpes1(&mut self) -> FPES1_W {
        FPES1_W { w: self }
    }
    #[doc = "Bit 5 - Fault Protection Noise Canceler"]
    #[inline(always)]
    pub fn fpnc1(&mut self) -> FPNC1_W {
        FPNC1_W { w: self }
    }
    #[doc = "Bit 6 - Fault Protection Mode Enable"]
    #[inline(always)]
    pub fn fpen1(&mut self) -> FPEN1_W {
        FPEN1_W { w: self }
    }
    #[doc = "Bit 7 - Fault Protection Interrupt Enable"]
    #[inline(always)]
    pub fn fpie1(&mut self) -> FPIE1_W {
        FPIE1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter Control Register D\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr1d](index.html) module"]
pub struct TCCR1D_SPEC;
impl crate::RegisterSpec for TCCR1D_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr1d::R](R) reader structure"]
impl crate::Readable for TCCR1D_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr1d::W](W) writer structure"]
impl crate::Writable for TCCR1D_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR1D to value 0"]
impl crate::Resettable for TCCR1D_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
