#[doc = "Register `TCCR1B` reader"]
pub struct R(crate::R<TCCR1B_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCCR1B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCCR1B_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCCR1B_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCCR1B` writer"]
pub struct W(crate::W<TCCR1B_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCCR1B_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCCR1B_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCCR1B_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Clock Select Bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CS1_A {
    #[doc = "0: No clock source (Timer/Counter stopped)"]
    NO_CLOCK = 0,
    #[doc = "1: Running, No Prescaling"]
    DIRECT = 1,
    #[doc = "2: Running, CLK/2"]
    PRESCALE_2 = 2,
    #[doc = "3: Running, CLK/4"]
    PRESCALE_4 = 3,
    #[doc = "4: Running, CLK/8"]
    PRESCALE_8 = 4,
    #[doc = "5: Running, CLK/16"]
    PRESCALE_16 = 5,
    #[doc = "6: Running, CLK/32"]
    PRESCALE_32 = 6,
    #[doc = "7: Running, CLK/64"]
    PRESCALE_64 = 7,
    #[doc = "8: Running, CLK/128"]
    PRESCALE_128 = 8,
    #[doc = "9: Running, CLK/256"]
    PRESCALE_256 = 9,
    #[doc = "10: Running, CLK/512"]
    PRESCALE_512 = 10,
    #[doc = "11: Running, CLK/1024"]
    PRESCALE_1024 = 11,
    #[doc = "12: Running, CLK/2048"]
    PRESCALE_2048 = 12,
    #[doc = "13: Running, CLK/4096"]
    PRESCALE_4096 = 13,
    #[doc = "14: Running, CLK/8192"]
    PRESCALE_8192 = 14,
    #[doc = "15: Running, CLK/16384"]
    PRESCALE_16384 = 15,
}
impl From<CS1_A> for u8 {
    #[inline(always)]
    fn from(variant: CS1_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CS1` reader - Clock Select Bits"]
pub struct CS1_R(crate::FieldReader<u8, CS1_A>);
impl CS1_R {
    pub(crate) fn new(bits: u8) -> Self {
        CS1_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CS1_A {
        match self.bits {
            0 => CS1_A::NO_CLOCK,
            1 => CS1_A::DIRECT,
            2 => CS1_A::PRESCALE_2,
            3 => CS1_A::PRESCALE_4,
            4 => CS1_A::PRESCALE_8,
            5 => CS1_A::PRESCALE_16,
            6 => CS1_A::PRESCALE_32,
            7 => CS1_A::PRESCALE_64,
            8 => CS1_A::PRESCALE_128,
            9 => CS1_A::PRESCALE_256,
            10 => CS1_A::PRESCALE_512,
            11 => CS1_A::PRESCALE_1024,
            12 => CS1_A::PRESCALE_2048,
            13 => CS1_A::PRESCALE_4096,
            14 => CS1_A::PRESCALE_8192,
            15 => CS1_A::PRESCALE_16384,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `NO_CLOCK`"]
    #[inline(always)]
    pub fn is_no_clock(&self) -> bool {
        **self == CS1_A::NO_CLOCK
    }
    #[doc = "Checks if the value of the field is `DIRECT`"]
    #[inline(always)]
    pub fn is_direct(&self) -> bool {
        **self == CS1_A::DIRECT
    }
    #[doc = "Checks if the value of the field is `PRESCALE_2`"]
    #[inline(always)]
    pub fn is_prescale_2(&self) -> bool {
        **self == CS1_A::PRESCALE_2
    }
    #[doc = "Checks if the value of the field is `PRESCALE_4`"]
    #[inline(always)]
    pub fn is_prescale_4(&self) -> bool {
        **self == CS1_A::PRESCALE_4
    }
    #[doc = "Checks if the value of the field is `PRESCALE_8`"]
    #[inline(always)]
    pub fn is_prescale_8(&self) -> bool {
        **self == CS1_A::PRESCALE_8
    }
    #[doc = "Checks if the value of the field is `PRESCALE_16`"]
    #[inline(always)]
    pub fn is_prescale_16(&self) -> bool {
        **self == CS1_A::PRESCALE_16
    }
    #[doc = "Checks if the value of the field is `PRESCALE_32`"]
    #[inline(always)]
    pub fn is_prescale_32(&self) -> bool {
        **self == CS1_A::PRESCALE_32
    }
    #[doc = "Checks if the value of the field is `PRESCALE_64`"]
    #[inline(always)]
    pub fn is_prescale_64(&self) -> bool {
        **self == CS1_A::PRESCALE_64
    }
    #[doc = "Checks if the value of the field is `PRESCALE_128`"]
    #[inline(always)]
    pub fn is_prescale_128(&self) -> bool {
        **self == CS1_A::PRESCALE_128
    }
    #[doc = "Checks if the value of the field is `PRESCALE_256`"]
    #[inline(always)]
    pub fn is_prescale_256(&self) -> bool {
        **self == CS1_A::PRESCALE_256
    }
    #[doc = "Checks if the value of the field is `PRESCALE_512`"]
    #[inline(always)]
    pub fn is_prescale_512(&self) -> bool {
        **self == CS1_A::PRESCALE_512
    }
    #[doc = "Checks if the value of the field is `PRESCALE_1024`"]
    #[inline(always)]
    pub fn is_prescale_1024(&self) -> bool {
        **self == CS1_A::PRESCALE_1024
    }
    #[doc = "Checks if the value of the field is `PRESCALE_2048`"]
    #[inline(always)]
    pub fn is_prescale_2048(&self) -> bool {
        **self == CS1_A::PRESCALE_2048
    }
    #[doc = "Checks if the value of the field is `PRESCALE_4096`"]
    #[inline(always)]
    pub fn is_prescale_4096(&self) -> bool {
        **self == CS1_A::PRESCALE_4096
    }
    #[doc = "Checks if the value of the field is `PRESCALE_8192`"]
    #[inline(always)]
    pub fn is_prescale_8192(&self) -> bool {
        **self == CS1_A::PRESCALE_8192
    }
    #[doc = "Checks if the value of the field is `PRESCALE_16384`"]
    #[inline(always)]
    pub fn is_prescale_16384(&self) -> bool {
        **self == CS1_A::PRESCALE_16384
    }
}
impl core::ops::Deref for CS1_R {
    type Target = crate::FieldReader<u8, CS1_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CS1` writer - Clock Select Bits"]
pub struct CS1_W<'a> {
    w: &'a mut W,
}
impl<'a> CS1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CS1_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "No clock source (Timer/Counter stopped)"]
    #[inline(always)]
    pub fn no_clock(self) -> &'a mut W {
        self.variant(CS1_A::NO_CLOCK)
    }
    #[doc = "Running, No Prescaling"]
    #[inline(always)]
    pub fn direct(self) -> &'a mut W {
        self.variant(CS1_A::DIRECT)
    }
    #[doc = "Running, CLK/2"]
    #[inline(always)]
    pub fn prescale_2(self) -> &'a mut W {
        self.variant(CS1_A::PRESCALE_2)
    }
    #[doc = "Running, CLK/4"]
    #[inline(always)]
    pub fn prescale_4(self) -> &'a mut W {
        self.variant(CS1_A::PRESCALE_4)
    }
    #[doc = "Running, CLK/8"]
    #[inline(always)]
    pub fn prescale_8(self) -> &'a mut W {
        self.variant(CS1_A::PRESCALE_8)
    }
    #[doc = "Running, CLK/16"]
    #[inline(always)]
    pub fn prescale_16(self) -> &'a mut W {
        self.variant(CS1_A::PRESCALE_16)
    }
    #[doc = "Running, CLK/32"]
    #[inline(always)]
    pub fn prescale_32(self) -> &'a mut W {
        self.variant(CS1_A::PRESCALE_32)
    }
    #[doc = "Running, CLK/64"]
    #[inline(always)]
    pub fn prescale_64(self) -> &'a mut W {
        self.variant(CS1_A::PRESCALE_64)
    }
    #[doc = "Running, CLK/128"]
    #[inline(always)]
    pub fn prescale_128(self) -> &'a mut W {
        self.variant(CS1_A::PRESCALE_128)
    }
    #[doc = "Running, CLK/256"]
    #[inline(always)]
    pub fn prescale_256(self) -> &'a mut W {
        self.variant(CS1_A::PRESCALE_256)
    }
    #[doc = "Running, CLK/512"]
    #[inline(always)]
    pub fn prescale_512(self) -> &'a mut W {
        self.variant(CS1_A::PRESCALE_512)
    }
    #[doc = "Running, CLK/1024"]
    #[inline(always)]
    pub fn prescale_1024(self) -> &'a mut W {
        self.variant(CS1_A::PRESCALE_1024)
    }
    #[doc = "Running, CLK/2048"]
    #[inline(always)]
    pub fn prescale_2048(self) -> &'a mut W {
        self.variant(CS1_A::PRESCALE_2048)
    }
    #[doc = "Running, CLK/4096"]
    #[inline(always)]
    pub fn prescale_4096(self) -> &'a mut W {
        self.variant(CS1_A::PRESCALE_4096)
    }
    #[doc = "Running, CLK/8192"]
    #[inline(always)]
    pub fn prescale_8192(self) -> &'a mut W {
        self.variant(CS1_A::PRESCALE_8192)
    }
    #[doc = "Running, CLK/16384"]
    #[inline(always)]
    pub fn prescale_16384(self) -> &'a mut W {
        self.variant(CS1_A::PRESCALE_16384)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u8 & 0x0f);
        self.w
    }
}
#[doc = "Dead Time Prescaler\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum DTPS1_A {
    #[doc = "0: 1x (no division)"]
    X1 = 0,
    #[doc = "1: 2x"]
    X2 = 1,
    #[doc = "2: 4x"]
    X4 = 2,
    #[doc = "3: 8x"]
    X8 = 3,
}
impl From<DTPS1_A> for u8 {
    #[inline(always)]
    fn from(variant: DTPS1_A) -> Self {
        variant as _
    }
}
#[doc = "Field `DTPS1` reader - Dead Time Prescaler"]
pub struct DTPS1_R(crate::FieldReader<u8, DTPS1_A>);
impl DTPS1_R {
    pub(crate) fn new(bits: u8) -> Self {
        DTPS1_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> DTPS1_A {
        match self.bits {
            0 => DTPS1_A::X1,
            1 => DTPS1_A::X2,
            2 => DTPS1_A::X4,
            3 => DTPS1_A::X8,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `X1`"]
    #[inline(always)]
    pub fn is_x1(&self) -> bool {
        **self == DTPS1_A::X1
    }
    #[doc = "Checks if the value of the field is `X2`"]
    #[inline(always)]
    pub fn is_x2(&self) -> bool {
        **self == DTPS1_A::X2
    }
    #[doc = "Checks if the value of the field is `X4`"]
    #[inline(always)]
    pub fn is_x4(&self) -> bool {
        **self == DTPS1_A::X4
    }
    #[doc = "Checks if the value of the field is `X8`"]
    #[inline(always)]
    pub fn is_x8(&self) -> bool {
        **self == DTPS1_A::X8
    }
}
impl core::ops::Deref for DTPS1_R {
    type Target = crate::FieldReader<u8, DTPS1_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTPS1` writer - Dead Time Prescaler"]
pub struct DTPS1_W<'a> {
    w: &'a mut W,
}
impl<'a> DTPS1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: DTPS1_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "1x (no division)"]
    #[inline(always)]
    pub fn x1(self) -> &'a mut W {
        self.variant(DTPS1_A::X1)
    }
    #[doc = "2x"]
    #[inline(always)]
    pub fn x2(self) -> &'a mut W {
        self.variant(DTPS1_A::X2)
    }
    #[doc = "4x"]
    #[inline(always)]
    pub fn x4(self) -> &'a mut W {
        self.variant(DTPS1_A::X4)
    }
    #[doc = "8x"]
    #[inline(always)]
    pub fn x8(self) -> &'a mut W {
        self.variant(DTPS1_A::X8)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `PSR1` reader - Timer/Counter 1 Prescaler reset"]
pub struct PSR1_R(crate::FieldReader<bool, bool>);
impl PSR1_R {
    pub(crate) fn new(bits: bool) -> Self {
        PSR1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PSR1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PSR1` writer - Timer/Counter 1 Prescaler reset"]
pub struct PSR1_W<'a> {
    w: &'a mut W,
}
impl<'a> PSR1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `PWM1X` reader - PWM Inversion Mode"]
pub struct PWM1X_R(crate::FieldReader<bool, bool>);
impl PWM1X_R {
    pub(crate) fn new(bits: bool) -> Self {
        PWM1X_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PWM1X_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PWM1X` writer - PWM Inversion Mode"]
pub struct PWM1X_W<'a> {
    w: &'a mut W,
}
impl<'a> PWM1X_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:3 - Clock Select Bits"]
    #[inline(always)]
    pub fn cs1(&self) -> CS1_R {
        CS1_R::new((self.bits & 0x0f) as u8)
    }
    #[doc = "Bits 4:5 - Dead Time Prescaler"]
    #[inline(always)]
    pub fn dtps1(&self) -> DTPS1_R {
        DTPS1_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bit 6 - Timer/Counter 1 Prescaler reset"]
    #[inline(always)]
    pub fn psr1(&self) -> PSR1_R {
        PSR1_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - PWM Inversion Mode"]
    #[inline(always)]
    pub fn pwm1x(&self) -> PWM1X_R {
        PWM1X_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:3 - Clock Select Bits"]
    #[inline(always)]
    pub fn cs1(&mut self) -> CS1_W {
        CS1_W { w: self }
    }
    #[doc = "Bits 4:5 - Dead Time Prescaler"]
    #[inline(always)]
    pub fn dtps1(&mut self) -> DTPS1_W {
        DTPS1_W { w: self }
    }
    #[doc = "Bit 6 - Timer/Counter 1 Prescaler reset"]
    #[inline(always)]
    pub fn psr1(&mut self) -> PSR1_W {
        PSR1_W { w: self }
    }
    #[doc = "Bit 7 - PWM Inversion Mode"]
    #[inline(always)]
    pub fn pwm1x(&mut self) -> PWM1X_W {
        PWM1X_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter Control Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tccr1b](index.html) module"]
pub struct TCCR1B_SPEC;
impl crate::RegisterSpec for TCCR1B_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tccr1b::R](R) reader structure"]
impl crate::Readable for TCCR1B_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tccr1b::W](W) writer structure"]
impl crate::Writable for TCCR1B_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCCR1B to value 0"]
impl crate::Resettable for TCCR1B_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
