#[doc = "Register `GIFR` reader"]
pub struct R(crate::R<GIFR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GIFR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<GIFR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<GIFR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GIFR` writer"]
pub struct W(crate::W<GIFR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GIFR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<GIFR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<GIFR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PCIF` reader - Pin Change Interrupt Flag"]
pub struct PCIF_R(crate::FieldReader<bool, bool>);
impl PCIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCIF` writer - Pin Change Interrupt Flag"]
pub struct PCIF_W<'a> {
    w: &'a mut W,
}
impl<'a> PCIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `INTF0` reader - External Interrupt Flag 0"]
pub struct INTF0_R(crate::FieldReader<bool, bool>);
impl INTF0_R {
    pub(crate) fn new(bits: bool) -> Self {
        INTF0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INTF0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INTF0` writer - External Interrupt Flag 0"]
pub struct INTF0_W<'a> {
    w: &'a mut W,
}
impl<'a> INTF0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bit 5 - Pin Change Interrupt Flag"]
    #[inline(always)]
    pub fn pcif(&self) -> PCIF_R {
        PCIF_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - External Interrupt Flag 0"]
    #[inline(always)]
    pub fn intf0(&self) -> INTF0_R {
        INTF0_R::new(((self.bits >> 6) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 5 - Pin Change Interrupt Flag"]
    #[inline(always)]
    pub fn pcif(&mut self) -> PCIF_W {
        PCIF_W { w: self }
    }
    #[doc = "Bit 6 - External Interrupt Flag 0"]
    #[inline(always)]
    pub fn intf0(&mut self) -> INTF0_W {
        INTF0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "General Interrupt Flag register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gifr](index.html) module"]
pub struct GIFR_SPEC;
impl crate::RegisterSpec for GIFR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [gifr::R](R) reader structure"]
impl crate::Readable for GIFR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gifr::W](W) writer structure"]
impl crate::Writable for GIFR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GIFR to value 0"]
impl crate::Resettable for GIFR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
