#[doc = "Register `UCSR0D` reader"]
pub struct R(crate::R<UCSR0D_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UCSR0D_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UCSR0D_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UCSR0D_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UCSR0D` writer"]
pub struct W(crate::W<UCSR0D_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UCSR0D_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UCSR0D_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UCSR0D_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SFDE0` reader - USART RX Start Frame Detection Enable"]
pub struct SFDE0_R(crate::FieldReader<bool, bool>);
impl SFDE0_R {
    pub(crate) fn new(bits: bool) -> Self {
        SFDE0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SFDE0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SFDE0` writer - USART RX Start Frame Detection Enable"]
pub struct SFDE0_W<'a> {
    w: &'a mut W,
}
impl<'a> SFDE0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `RXS0` reader - USART RX Start Flag"]
pub struct RXS0_R(crate::FieldReader<bool, bool>);
impl RXS0_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXS0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXS0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXS0` writer - USART RX Start Flag"]
pub struct RXS0_W<'a> {
    w: &'a mut W,
}
impl<'a> RXS0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `RXSIE0` reader - USART RX Start Interrupt Enable"]
pub struct RXSIE0_R(crate::FieldReader<bool, bool>);
impl RXSIE0_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXSIE0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXSIE0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXSIE0` writer - USART RX Start Interrupt Enable"]
pub struct RXSIE0_W<'a> {
    w: &'a mut W,
}
impl<'a> RXSIE0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 5 - USART RX Start Frame Detection Enable"]
    #[inline(always)]
    pub fn sfde0(&self) -> SFDE0_R {
        SFDE0_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - USART RX Start Flag"]
    #[inline(always)]
    pub fn rxs0(&self) -> RXS0_R {
        RXS0_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - USART RX Start Interrupt Enable"]
    #[inline(always)]
    pub fn rxsie0(&self) -> RXSIE0_R {
        RXSIE0_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 5 - USART RX Start Frame Detection Enable"]
    #[inline(always)]
    pub fn sfde0(&mut self) -> SFDE0_W {
        SFDE0_W { w: self }
    }
    #[doc = "Bit 6 - USART RX Start Flag"]
    #[inline(always)]
    pub fn rxs0(&mut self) -> RXS0_W {
        RXS0_W { w: self }
    }
    #[doc = "Bit 7 - USART RX Start Interrupt Enable"]
    #[inline(always)]
    pub fn rxsie0(&mut self) -> RXSIE0_W {
        RXSIE0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USART Control and Status Register D\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ucsr0d](index.html) module"]
pub struct UCSR0D_SPEC;
impl crate::RegisterSpec for UCSR0D_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ucsr0d::R](R) reader structure"]
impl crate::Readable for UCSR0D_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ucsr0d::W](W) writer structure"]
impl crate::Writable for UCSR0D_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UCSR0D to value 0"]
impl crate::Resettable for UCSR0D_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
