#[doc = "Register `TWSSRA` reader"]
pub struct R(crate::R<TWSSRA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TWSSRA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TWSSRA_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TWSSRA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TWSSRA` writer"]
pub struct W(crate::W<TWSSRA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TWSSRA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TWSSRA_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TWSSRA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TWAS` reader - TWI Address or Stop"]
pub struct TWAS_R(crate::FieldReader<bool, bool>);
impl TWAS_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWAS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWAS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWAS` writer - TWI Address or Stop"]
pub struct TWAS_W<'a> {
    w: &'a mut W,
}
impl<'a> TWAS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `TWDIR` reader - TWI Read/Write Direction"]
pub struct TWDIR_R(crate::FieldReader<bool, bool>);
impl TWDIR_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWDIR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWDIR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWDIR` writer - TWI Read/Write Direction"]
pub struct TWDIR_W<'a> {
    w: &'a mut W,
}
impl<'a> TWDIR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `TWBE` reader - TWI Bus Error"]
pub struct TWBE_R(crate::FieldReader<bool, bool>);
impl TWBE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWBE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWBE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWBE` writer - TWI Bus Error"]
pub struct TWBE_W<'a> {
    w: &'a mut W,
}
impl<'a> TWBE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `TWC` reader - TWI Collision"]
pub struct TWC_R(crate::FieldReader<bool, bool>);
impl TWC_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWC` writer - TWI Collision"]
pub struct TWC_W<'a> {
    w: &'a mut W,
}
impl<'a> TWC_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `TWRA` reader - TWI Receive Acknowledge"]
pub struct TWRA_R(crate::FieldReader<bool, bool>);
impl TWRA_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWRA_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWRA_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWRA` writer - TWI Receive Acknowledge"]
pub struct TWRA_W<'a> {
    w: &'a mut W,
}
impl<'a> TWRA_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `TWCH` reader - TWI Clock Hold"]
pub struct TWCH_R(crate::FieldReader<bool, bool>);
impl TWCH_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWCH_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWCH_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWCH` writer - TWI Clock Hold"]
pub struct TWCH_W<'a> {
    w: &'a mut W,
}
impl<'a> TWCH_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `TWASIF` reader - TWI Address/Stop Interrupt Flag"]
pub struct TWASIF_R(crate::FieldReader<bool, bool>);
impl TWASIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWASIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWASIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWASIF` writer - TWI Address/Stop Interrupt Flag"]
pub struct TWASIF_W<'a> {
    w: &'a mut W,
}
impl<'a> TWASIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `TWDIF` reader - TWI Data Interrupt Flag."]
pub struct TWDIF_R(crate::FieldReader<bool, bool>);
impl TWDIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWDIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWDIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWDIF` writer - TWI Data Interrupt Flag."]
pub struct TWDIF_W<'a> {
    w: &'a mut W,
}
impl<'a> TWDIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - TWI Address or Stop"]
    #[inline(always)]
    pub fn twas(&self) -> TWAS_R {
        TWAS_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - TWI Read/Write Direction"]
    #[inline(always)]
    pub fn twdir(&self) -> TWDIR_R {
        TWDIR_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - TWI Bus Error"]
    #[inline(always)]
    pub fn twbe(&self) -> TWBE_R {
        TWBE_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - TWI Collision"]
    #[inline(always)]
    pub fn twc(&self) -> TWC_R {
        TWC_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - TWI Receive Acknowledge"]
    #[inline(always)]
    pub fn twra(&self) -> TWRA_R {
        TWRA_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - TWI Clock Hold"]
    #[inline(always)]
    pub fn twch(&self) -> TWCH_R {
        TWCH_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - TWI Address/Stop Interrupt Flag"]
    #[inline(always)]
    pub fn twasif(&self) -> TWASIF_R {
        TWASIF_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - TWI Data Interrupt Flag."]
    #[inline(always)]
    pub fn twdif(&self) -> TWDIF_R {
        TWDIF_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - TWI Address or Stop"]
    #[inline(always)]
    pub fn twas(&mut self) -> TWAS_W {
        TWAS_W { w: self }
    }
    #[doc = "Bit 1 - TWI Read/Write Direction"]
    #[inline(always)]
    pub fn twdir(&mut self) -> TWDIR_W {
        TWDIR_W { w: self }
    }
    #[doc = "Bit 2 - TWI Bus Error"]
    #[inline(always)]
    pub fn twbe(&mut self) -> TWBE_W {
        TWBE_W { w: self }
    }
    #[doc = "Bit 3 - TWI Collision"]
    #[inline(always)]
    pub fn twc(&mut self) -> TWC_W {
        TWC_W { w: self }
    }
    #[doc = "Bit 4 - TWI Receive Acknowledge"]
    #[inline(always)]
    pub fn twra(&mut self) -> TWRA_W {
        TWRA_W { w: self }
    }
    #[doc = "Bit 5 - TWI Clock Hold"]
    #[inline(always)]
    pub fn twch(&mut self) -> TWCH_W {
        TWCH_W { w: self }
    }
    #[doc = "Bit 6 - TWI Address/Stop Interrupt Flag"]
    #[inline(always)]
    pub fn twasif(&mut self) -> TWASIF_W {
        TWASIF_W { w: self }
    }
    #[doc = "Bit 7 - TWI Data Interrupt Flag."]
    #[inline(always)]
    pub fn twdif(&mut self) -> TWDIF_W {
        TWDIF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "TWI Slave Status Register A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [twssra](index.html) module"]
pub struct TWSSRA_SPEC;
impl crate::RegisterSpec for TWSSRA_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [twssra::R](R) reader structure"]
impl crate::Readable for TWSSRA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [twssra::W](W) writer structure"]
impl crate::Writable for TWSSRA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TWSSRA to value 0"]
impl crate::Resettable for TWSSRA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
