#[doc = "Register `TWSAM` reader"]
pub struct R(crate::R<TWSAM_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TWSAM_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TWSAM_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TWSAM_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TWSAM` writer"]
pub struct W(crate::W<TWSAM_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TWSAM_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TWSAM_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TWSAM_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TWAE` reader - TWI Address Enable"]
pub struct TWAE_R(crate::FieldReader<bool, bool>);
impl TWAE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TWAE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWAE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWAE` writer - TWI Address Enable"]
pub struct TWAE_W<'a> {
    w: &'a mut W,
}
impl<'a> TWAE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `TWSAM` reader - TWI Address Mask Bits"]
pub struct TWSAM_R(crate::FieldReader<u8, u8>);
impl TWSAM_R {
    pub(crate) fn new(bits: u8) -> Self {
        TWSAM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TWSAM_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TWSAM` writer - TWI Address Mask Bits"]
pub struct TWSAM_W<'a> {
    w: &'a mut W,
}
impl<'a> TWSAM_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x7f << 1)) | ((value as u8 & 0x7f) << 1);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - TWI Address Enable"]
    #[inline(always)]
    pub fn twae(&self) -> TWAE_R {
        TWAE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bits 1:7 - TWI Address Mask Bits"]
    #[inline(always)]
    pub fn twsam(&self) -> TWSAM_R {
        TWSAM_R::new(((self.bits >> 1) & 0x7f) as u8)
    }
}
impl W {
    #[doc = "Bit 0 - TWI Address Enable"]
    #[inline(always)]
    pub fn twae(&mut self) -> TWAE_W {
        TWAE_W { w: self }
    }
    #[doc = "Bits 1:7 - TWI Address Mask Bits"]
    #[inline(always)]
    pub fn twsam(&mut self) -> TWSAM_W {
        TWSAM_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "TWI Slave Address Mask Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [twsam](index.html) module"]
pub struct TWSAM_SPEC;
impl crate::RegisterSpec for TWSAM_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [twsam::R](R) reader structure"]
impl crate::Readable for TWSAM_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [twsam::W](W) writer structure"]
impl crate::Writable for TWSAM_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TWSAM to value 0"]
impl crate::Resettable for TWSAM_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
