#[doc = "Register `TIMSK2` reader"]
pub struct R(crate::R<TIMSK2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TIMSK2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TIMSK2_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TIMSK2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TIMSK2` writer"]
pub struct W(crate::W<TIMSK2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TIMSK2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TIMSK2_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TIMSK2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TOIE2` reader - Timer/Counter2 Overflow Interrupt Enable"]
pub struct TOIE2_R(crate::FieldReader<bool, bool>);
impl TOIE2_R {
    pub(crate) fn new(bits: bool) -> Self {
        TOIE2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TOIE2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TOIE2` writer - Timer/Counter2 Overflow Interrupt Enable"]
pub struct TOIE2_W<'a> {
    w: &'a mut W,
}
impl<'a> TOIE2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `OCIE2A` reader - Timer/Counter2 Output Compare A Match Interrupt Enable"]
pub struct OCIE2A_R(crate::FieldReader<bool, bool>);
impl OCIE2A_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCIE2A_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCIE2A_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCIE2A` writer - Timer/Counter2 Output Compare A Match Interrupt Enable"]
pub struct OCIE2A_W<'a> {
    w: &'a mut W,
}
impl<'a> OCIE2A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `OCIE2B` reader - Timer/Counter2 Output Compare B Match Interrupt Enable"]
pub struct OCIE2B_R(crate::FieldReader<bool, bool>);
impl OCIE2B_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCIE2B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCIE2B_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCIE2B` writer - Timer/Counter2 Output Compare B Match Interrupt Enable"]
pub struct OCIE2B_W<'a> {
    w: &'a mut W,
}
impl<'a> OCIE2B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `ICIE2` reader - Timer/Counter2 Input Capture Interrupt Enable"]
pub struct ICIE2_R(crate::FieldReader<bool, bool>);
impl ICIE2_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICIE2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICIE2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICIE2` writer - Timer/Counter2 Input Capture Interrupt Enable"]
pub struct ICIE2_W<'a> {
    w: &'a mut W,
}
impl<'a> ICIE2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Timer/Counter2 Overflow Interrupt Enable"]
    #[inline(always)]
    pub fn toie2(&self) -> TOIE2_R {
        TOIE2_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Timer/Counter2 Output Compare A Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie2a(&self) -> OCIE2A_R {
        OCIE2A_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Timer/Counter2 Output Compare B Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie2b(&self) -> OCIE2B_R {
        OCIE2B_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Timer/Counter2 Input Capture Interrupt Enable"]
    #[inline(always)]
    pub fn icie2(&self) -> ICIE2_R {
        ICIE2_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Timer/Counter2 Overflow Interrupt Enable"]
    #[inline(always)]
    pub fn toie2(&mut self) -> TOIE2_W {
        TOIE2_W { w: self }
    }
    #[doc = "Bit 1 - Timer/Counter2 Output Compare A Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie2a(&mut self) -> OCIE2A_W {
        OCIE2A_W { w: self }
    }
    #[doc = "Bit 2 - Timer/Counter2 Output Compare B Match Interrupt Enable"]
    #[inline(always)]
    pub fn ocie2b(&mut self) -> OCIE2B_W {
        OCIE2B_W { w: self }
    }
    #[doc = "Bit 5 - Timer/Counter2 Input Capture Interrupt Enable"]
    #[inline(always)]
    pub fn icie2(&mut self) -> ICIE2_W {
        ICIE2_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter2 Interrupt Mask Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [timsk2](index.html) module"]
pub struct TIMSK2_SPEC;
impl crate::RegisterSpec for TIMSK2_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [timsk2::R](R) reader structure"]
impl crate::Readable for TIMSK2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [timsk2::W](W) writer structure"]
impl crate::Writable for TIMSK2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TIMSK2 to value 0"]
impl crate::Resettable for TIMSK2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
