#[doc = "Register `TIFR2` reader"]
pub struct R(crate::R<TIFR2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TIFR2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TIFR2_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TIFR2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TIFR2` writer"]
pub struct W(crate::W<TIFR2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TIFR2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TIFR2_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TIFR2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TOV2` reader - Timer/Counter2 Overflow Flag"]
pub struct TOV2_R(crate::FieldReader<bool, bool>);
impl TOV2_R {
    pub(crate) fn new(bits: bool) -> Self {
        TOV2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TOV2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TOV2` writer - Timer/Counter2 Overflow Flag"]
pub struct TOV2_W<'a> {
    w: &'a mut W,
}
impl<'a> TOV2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `OCF2A` reader - Timer/Counter2 Output Compare A Match Flag"]
pub struct OCF2A_R(crate::FieldReader<bool, bool>);
impl OCF2A_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCF2A_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCF2A_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCF2A` writer - Timer/Counter2 Output Compare A Match Flag"]
pub struct OCF2A_W<'a> {
    w: &'a mut W,
}
impl<'a> OCF2A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `OCF2B` reader - Timer/Counter2 Output Compare B Match Flag"]
pub struct OCF2B_R(crate::FieldReader<bool, bool>);
impl OCF2B_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCF2B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCF2B_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCF2B` writer - Timer/Counter2 Output Compare B Match Flag"]
pub struct OCF2B_W<'a> {
    w: &'a mut W,
}
impl<'a> OCF2B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `ICF2` reader - Timer/Counter2 Input Capture Flag"]
pub struct ICF2_R(crate::FieldReader<bool, bool>);
impl ICF2_R {
    pub(crate) fn new(bits: bool) -> Self {
        ICF2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ICF2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ICF2` writer - Timer/Counter2 Input Capture Flag"]
pub struct ICF2_W<'a> {
    w: &'a mut W,
}
impl<'a> ICF2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Timer/Counter2 Overflow Flag"]
    #[inline(always)]
    pub fn tov2(&self) -> TOV2_R {
        TOV2_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Timer/Counter2 Output Compare A Match Flag"]
    #[inline(always)]
    pub fn ocf2a(&self) -> OCF2A_R {
        OCF2A_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Timer/Counter2 Output Compare B Match Flag"]
    #[inline(always)]
    pub fn ocf2b(&self) -> OCF2B_R {
        OCF2B_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Timer/Counter2 Input Capture Flag"]
    #[inline(always)]
    pub fn icf2(&self) -> ICF2_R {
        ICF2_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Timer/Counter2 Overflow Flag"]
    #[inline(always)]
    pub fn tov2(&mut self) -> TOV2_W {
        TOV2_W { w: self }
    }
    #[doc = "Bit 1 - Timer/Counter2 Output Compare A Match Flag"]
    #[inline(always)]
    pub fn ocf2a(&mut self) -> OCF2A_W {
        OCF2A_W { w: self }
    }
    #[doc = "Bit 2 - Timer/Counter2 Output Compare B Match Flag"]
    #[inline(always)]
    pub fn ocf2b(&mut self) -> OCF2B_W {
        OCF2B_W { w: self }
    }
    #[doc = "Bit 5 - Timer/Counter2 Input Capture Flag"]
    #[inline(always)]
    pub fn icf2(&mut self) -> ICF2_W {
        ICF2_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter Interrupt Flag register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tifr2](index.html) module"]
pub struct TIFR2_SPEC;
impl crate::RegisterSpec for TIFR2_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tifr2::R](R) reader structure"]
impl crate::Readable for TIFR2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tifr2::W](W) writer structure"]
impl crate::Writable for TIFR2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TIFR2 to value 0"]
impl crate::Resettable for TIFR2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
