#[doc = "Register `EXTENDED` reader"]
pub struct R(crate::R<EXTENDED_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<EXTENDED_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<EXTENDED_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<EXTENDED_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `EXTENDED` writer"]
pub struct W(crate::W<EXTENDED_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<EXTENDED_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<EXTENDED_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<EXTENDED_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SELFPRGEN` reader - Self Programming enable"]
pub struct SELFPRGEN_R(crate::FieldReader<bool, bool>);
impl SELFPRGEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        SELFPRGEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SELFPRGEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SELFPRGEN` writer - Self Programming enable"]
pub struct SELFPRGEN_W<'a> {
    w: &'a mut W,
}
impl<'a> SELFPRGEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "BOD mode of operation when the device is active or idle\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum BODACT_A {
    #[doc = "1: Sampled"]
    BOD_SAMPLED = 1,
    #[doc = "2: Enabled"]
    BOD_ENABLED = 2,
    #[doc = "3: Disabled"]
    BOD_DISABLED = 3,
}
impl From<BODACT_A> for u8 {
    #[inline(always)]
    fn from(variant: BODACT_A) -> Self {
        variant as _
    }
}
#[doc = "Field `BODACT` reader - BOD mode of operation when the device is active or idle"]
pub struct BODACT_R(crate::FieldReader<u8, BODACT_A>);
impl BODACT_R {
    pub(crate) fn new(bits: u8) -> Self {
        BODACT_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<BODACT_A> {
        match self.bits {
            1 => Some(BODACT_A::BOD_SAMPLED),
            2 => Some(BODACT_A::BOD_ENABLED),
            3 => Some(BODACT_A::BOD_DISABLED),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `BOD_SAMPLED`"]
    #[inline(always)]
    pub fn is_bod_sampled(&self) -> bool {
        **self == BODACT_A::BOD_SAMPLED
    }
    #[doc = "Checks if the value of the field is `BOD_ENABLED`"]
    #[inline(always)]
    pub fn is_bod_enabled(&self) -> bool {
        **self == BODACT_A::BOD_ENABLED
    }
    #[doc = "Checks if the value of the field is `BOD_DISABLED`"]
    #[inline(always)]
    pub fn is_bod_disabled(&self) -> bool {
        **self == BODACT_A::BOD_DISABLED
    }
}
impl core::ops::Deref for BODACT_R {
    type Target = crate::FieldReader<u8, BODACT_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BODACT` writer - BOD mode of operation when the device is active or idle"]
pub struct BODACT_W<'a> {
    w: &'a mut W,
}
impl<'a> BODACT_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: BODACT_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Sampled"]
    #[inline(always)]
    pub fn bod_sampled(self) -> &'a mut W {
        self.variant(BODACT_A::BOD_SAMPLED)
    }
    #[doc = "Enabled"]
    #[inline(always)]
    pub fn bod_enabled(self) -> &'a mut W {
        self.variant(BODACT_A::BOD_ENABLED)
    }
    #[doc = "Disabled"]
    #[inline(always)]
    pub fn bod_disabled(self) -> &'a mut W {
        self.variant(BODACT_A::BOD_DISABLED)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 1)) | ((value as u8 & 0x03) << 1);
        self.w
    }
}
#[doc = "BOD mode of operation when the device is in sleep mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum BODPD_A {
    #[doc = "1: Sampled"]
    BOD_SAMPLED = 1,
    #[doc = "2: Enabled"]
    BOD_ENABLED = 2,
    #[doc = "3: Disabled"]
    BOD_DISABLED = 3,
}
impl From<BODPD_A> for u8 {
    #[inline(always)]
    fn from(variant: BODPD_A) -> Self {
        variant as _
    }
}
#[doc = "Field `BODPD` reader - BOD mode of operation when the device is in sleep mode"]
pub struct BODPD_R(crate::FieldReader<u8, BODPD_A>);
impl BODPD_R {
    pub(crate) fn new(bits: u8) -> Self {
        BODPD_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<BODPD_A> {
        match self.bits {
            1 => Some(BODPD_A::BOD_SAMPLED),
            2 => Some(BODPD_A::BOD_ENABLED),
            3 => Some(BODPD_A::BOD_DISABLED),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `BOD_SAMPLED`"]
    #[inline(always)]
    pub fn is_bod_sampled(&self) -> bool {
        **self == BODPD_A::BOD_SAMPLED
    }
    #[doc = "Checks if the value of the field is `BOD_ENABLED`"]
    #[inline(always)]
    pub fn is_bod_enabled(&self) -> bool {
        **self == BODPD_A::BOD_ENABLED
    }
    #[doc = "Checks if the value of the field is `BOD_DISABLED`"]
    #[inline(always)]
    pub fn is_bod_disabled(&self) -> bool {
        **self == BODPD_A::BOD_DISABLED
    }
}
impl core::ops::Deref for BODPD_R {
    type Target = crate::FieldReader<u8, BODPD_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BODPD` writer - BOD mode of operation when the device is in sleep mode"]
pub struct BODPD_W<'a> {
    w: &'a mut W,
}
impl<'a> BODPD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: BODPD_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Sampled"]
    #[inline(always)]
    pub fn bod_sampled(self) -> &'a mut W {
        self.variant(BODPD_A::BOD_SAMPLED)
    }
    #[doc = "Enabled"]
    #[inline(always)]
    pub fn bod_enabled(self) -> &'a mut W {
        self.variant(BODPD_A::BOD_ENABLED)
    }
    #[doc = "Disabled"]
    #[inline(always)]
    pub fn bod_disabled(self) -> &'a mut W {
        self.variant(BODPD_A::BOD_DISABLED)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 3)) | ((value as u8 & 0x03) << 3);
        self.w
    }
}
#[doc = "Frequency selection for internal ULP oscillator. The selection only affects system clock, watchdog and reset timeout always use 32 kHz clock.\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum ULPOSCSEL_A {
    #[doc = "3: 512 kHz"]
    ULPOSC_512KHZ = 3,
    #[doc = "4: 256 kHz"]
    ULPOSC_256KHZ = 4,
    #[doc = "5: 128 kHz"]
    ULPOSC_128KHZ = 5,
    #[doc = "6: 64 kHz"]
    ULPOSC_64KHZ = 6,
    #[doc = "7: 32 kHz"]
    ULPOSC_32KHZ = 7,
}
impl From<ULPOSCSEL_A> for u8 {
    #[inline(always)]
    fn from(variant: ULPOSCSEL_A) -> Self {
        variant as _
    }
}
#[doc = "Field `ULPOSCSEL` reader - Frequency selection for internal ULP oscillator. The selection only affects system clock, watchdog and reset timeout always use 32 kHz clock."]
pub struct ULPOSCSEL_R(crate::FieldReader<u8, ULPOSCSEL_A>);
impl ULPOSCSEL_R {
    pub(crate) fn new(bits: u8) -> Self {
        ULPOSCSEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<ULPOSCSEL_A> {
        match self.bits {
            3 => Some(ULPOSCSEL_A::ULPOSC_512KHZ),
            4 => Some(ULPOSCSEL_A::ULPOSC_256KHZ),
            5 => Some(ULPOSCSEL_A::ULPOSC_128KHZ),
            6 => Some(ULPOSCSEL_A::ULPOSC_64KHZ),
            7 => Some(ULPOSCSEL_A::ULPOSC_32KHZ),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `ULPOSC_512KHZ`"]
    #[inline(always)]
    pub fn is_ulposc_512khz(&self) -> bool {
        **self == ULPOSCSEL_A::ULPOSC_512KHZ
    }
    #[doc = "Checks if the value of the field is `ULPOSC_256KHZ`"]
    #[inline(always)]
    pub fn is_ulposc_256khz(&self) -> bool {
        **self == ULPOSCSEL_A::ULPOSC_256KHZ
    }
    #[doc = "Checks if the value of the field is `ULPOSC_128KHZ`"]
    #[inline(always)]
    pub fn is_ulposc_128khz(&self) -> bool {
        **self == ULPOSCSEL_A::ULPOSC_128KHZ
    }
    #[doc = "Checks if the value of the field is `ULPOSC_64KHZ`"]
    #[inline(always)]
    pub fn is_ulposc_64khz(&self) -> bool {
        **self == ULPOSCSEL_A::ULPOSC_64KHZ
    }
    #[doc = "Checks if the value of the field is `ULPOSC_32KHZ`"]
    #[inline(always)]
    pub fn is_ulposc_32khz(&self) -> bool {
        **self == ULPOSCSEL_A::ULPOSC_32KHZ
    }
}
impl core::ops::Deref for ULPOSCSEL_R {
    type Target = crate::FieldReader<u8, ULPOSCSEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ULPOSCSEL` writer - Frequency selection for internal ULP oscillator. The selection only affects system clock, watchdog and reset timeout always use 32 kHz clock."]
pub struct ULPOSCSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> ULPOSCSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: ULPOSCSEL_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "512 kHz"]
    #[inline(always)]
    pub fn ulposc_512khz(self) -> &'a mut W {
        self.variant(ULPOSCSEL_A::ULPOSC_512KHZ)
    }
    #[doc = "256 kHz"]
    #[inline(always)]
    pub fn ulposc_256khz(self) -> &'a mut W {
        self.variant(ULPOSCSEL_A::ULPOSC_256KHZ)
    }
    #[doc = "128 kHz"]
    #[inline(always)]
    pub fn ulposc_128khz(self) -> &'a mut W {
        self.variant(ULPOSCSEL_A::ULPOSC_128KHZ)
    }
    #[doc = "64 kHz"]
    #[inline(always)]
    pub fn ulposc_64khz(self) -> &'a mut W {
        self.variant(ULPOSCSEL_A::ULPOSC_64KHZ)
    }
    #[doc = "32 kHz"]
    #[inline(always)]
    pub fn ulposc_32khz(self) -> &'a mut W {
        self.variant(ULPOSCSEL_A::ULPOSC_32KHZ)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 5)) | ((value as u8 & 0x07) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Self Programming enable"]
    #[inline(always)]
    pub fn selfprgen(&self) -> SELFPRGEN_R {
        SELFPRGEN_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bits 1:2 - BOD mode of operation when the device is active or idle"]
    #[inline(always)]
    pub fn bodact(&self) -> BODACT_R {
        BODACT_R::new(((self.bits >> 1) & 0x03) as u8)
    }
    #[doc = "Bits 3:4 - BOD mode of operation when the device is in sleep mode"]
    #[inline(always)]
    pub fn bodpd(&self) -> BODPD_R {
        BODPD_R::new(((self.bits >> 3) & 0x03) as u8)
    }
    #[doc = "Bits 5:7 - Frequency selection for internal ULP oscillator. The selection only affects system clock, watchdog and reset timeout always use 32 kHz clock."]
    #[inline(always)]
    pub fn ulposcsel(&self) -> ULPOSCSEL_R {
        ULPOSCSEL_R::new(((self.bits >> 5) & 0x07) as u8)
    }
}
impl W {
    #[doc = "Bit 0 - Self Programming enable"]
    #[inline(always)]
    pub fn selfprgen(&mut self) -> SELFPRGEN_W {
        SELFPRGEN_W { w: self }
    }
    #[doc = "Bits 1:2 - BOD mode of operation when the device is active or idle"]
    #[inline(always)]
    pub fn bodact(&mut self) -> BODACT_W {
        BODACT_W { w: self }
    }
    #[doc = "Bits 3:4 - BOD mode of operation when the device is in sleep mode"]
    #[inline(always)]
    pub fn bodpd(&mut self) -> BODPD_W {
        BODPD_W { w: self }
    }
    #[doc = "Bits 5:7 - Frequency selection for internal ULP oscillator. The selection only affects system clock, watchdog and reset timeout always use 32 kHz clock."]
    #[inline(always)]
    pub fn ulposcsel(&mut self) -> ULPOSCSEL_W {
        ULPOSCSEL_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "No Description.\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [extended](index.html) module"]
pub struct EXTENDED_SPEC;
impl crate::RegisterSpec for EXTENDED_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [extended::R](R) reader structure"]
impl crate::Readable for EXTENDED_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [extended::W](W) writer structure"]
impl crate::Writable for EXTENDED_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets EXTENDED to value 0"]
impl crate::Resettable for EXTENDED_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
