#[doc = "Register `PCMSK0` reader"]
pub struct R(crate::R<PCMSK0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PCMSK0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PCMSK0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PCMSK0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PCMSK0` writer"]
pub struct W(crate::W<PCMSK0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PCMSK0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PCMSK0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PCMSK0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PCINT0` reader - Pin Change Enable Mask 0 Bit 0"]
pub struct PCINT0_R(crate::FieldReader<bool, bool>);
impl PCINT0_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCINT0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCINT0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCINT0` writer - Pin Change Enable Mask 0 Bit 0"]
pub struct PCINT0_W<'a> {
    w: &'a mut W,
}
impl<'a> PCINT0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `PCINT1` reader - Pin Change Enable Mask 0 Bit 1"]
pub struct PCINT1_R(crate::FieldReader<bool, bool>);
impl PCINT1_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCINT1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCINT1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCINT1` writer - Pin Change Enable Mask 0 Bit 1"]
pub struct PCINT1_W<'a> {
    w: &'a mut W,
}
impl<'a> PCINT1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `PCINT2` reader - Pin Change Enable Mask 0 Bit 2"]
pub struct PCINT2_R(crate::FieldReader<bool, bool>);
impl PCINT2_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCINT2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCINT2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCINT2` writer - Pin Change Enable Mask 0 Bit 2"]
pub struct PCINT2_W<'a> {
    w: &'a mut W,
}
impl<'a> PCINT2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `PCINT3` reader - Pin Change Enable Mask 0 Bit 3"]
pub struct PCINT3_R(crate::FieldReader<bool, bool>);
impl PCINT3_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCINT3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCINT3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCINT3` writer - Pin Change Enable Mask 0 Bit 3"]
pub struct PCINT3_W<'a> {
    w: &'a mut W,
}
impl<'a> PCINT3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `PCINT4` reader - Pin Change Enable Mask 0 Bit 4"]
pub struct PCINT4_R(crate::FieldReader<bool, bool>);
impl PCINT4_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCINT4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCINT4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCINT4` writer - Pin Change Enable Mask 0 Bit 4"]
pub struct PCINT4_W<'a> {
    w: &'a mut W,
}
impl<'a> PCINT4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `PCINT5` reader - Pin Change Enable Mask 0 Bit 5"]
pub struct PCINT5_R(crate::FieldReader<bool, bool>);
impl PCINT5_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCINT5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCINT5_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCINT5` writer - Pin Change Enable Mask 0 Bit 5"]
pub struct PCINT5_W<'a> {
    w: &'a mut W,
}
impl<'a> PCINT5_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `PCINT6` reader - Pin Change Enable Mask 0 Bit 6"]
pub struct PCINT6_R(crate::FieldReader<bool, bool>);
impl PCINT6_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCINT6_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCINT6_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCINT6` writer - Pin Change Enable Mask 0 Bit 6"]
pub struct PCINT6_W<'a> {
    w: &'a mut W,
}
impl<'a> PCINT6_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `PCINT7` reader - Pin Change Enable Mask 0 Bit 7"]
pub struct PCINT7_R(crate::FieldReader<bool, bool>);
impl PCINT7_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCINT7_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCINT7_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCINT7` writer - Pin Change Enable Mask 0 Bit 7"]
pub struct PCINT7_W<'a> {
    w: &'a mut W,
}
impl<'a> PCINT7_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Pin Change Enable Mask 0 Bit 0"]
    #[inline(always)]
    pub fn pcint0(&self) -> PCINT0_R {
        PCINT0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Pin Change Enable Mask 0 Bit 1"]
    #[inline(always)]
    pub fn pcint1(&self) -> PCINT1_R {
        PCINT1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Pin Change Enable Mask 0 Bit 2"]
    #[inline(always)]
    pub fn pcint2(&self) -> PCINT2_R {
        PCINT2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Pin Change Enable Mask 0 Bit 3"]
    #[inline(always)]
    pub fn pcint3(&self) -> PCINT3_R {
        PCINT3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Pin Change Enable Mask 0 Bit 4"]
    #[inline(always)]
    pub fn pcint4(&self) -> PCINT4_R {
        PCINT4_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Pin Change Enable Mask 0 Bit 5"]
    #[inline(always)]
    pub fn pcint5(&self) -> PCINT5_R {
        PCINT5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Pin Change Enable Mask 0 Bit 6"]
    #[inline(always)]
    pub fn pcint6(&self) -> PCINT6_R {
        PCINT6_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Pin Change Enable Mask 0 Bit 7"]
    #[inline(always)]
    pub fn pcint7(&self) -> PCINT7_R {
        PCINT7_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Pin Change Enable Mask 0 Bit 0"]
    #[inline(always)]
    pub fn pcint0(&mut self) -> PCINT0_W {
        PCINT0_W { w: self }
    }
    #[doc = "Bit 1 - Pin Change Enable Mask 0 Bit 1"]
    #[inline(always)]
    pub fn pcint1(&mut self) -> PCINT1_W {
        PCINT1_W { w: self }
    }
    #[doc = "Bit 2 - Pin Change Enable Mask 0 Bit 2"]
    #[inline(always)]
    pub fn pcint2(&mut self) -> PCINT2_W {
        PCINT2_W { w: self }
    }
    #[doc = "Bit 3 - Pin Change Enable Mask 0 Bit 3"]
    #[inline(always)]
    pub fn pcint3(&mut self) -> PCINT3_W {
        PCINT3_W { w: self }
    }
    #[doc = "Bit 4 - Pin Change Enable Mask 0 Bit 4"]
    #[inline(always)]
    pub fn pcint4(&mut self) -> PCINT4_W {
        PCINT4_W { w: self }
    }
    #[doc = "Bit 5 - Pin Change Enable Mask 0 Bit 5"]
    #[inline(always)]
    pub fn pcint5(&mut self) -> PCINT5_W {
        PCINT5_W { w: self }
    }
    #[doc = "Bit 6 - Pin Change Enable Mask 0 Bit 6"]
    #[inline(always)]
    pub fn pcint6(&mut self) -> PCINT6_W {
        PCINT6_W { w: self }
    }
    #[doc = "Bit 7 - Pin Change Enable Mask 0 Bit 7"]
    #[inline(always)]
    pub fn pcint7(&mut self) -> PCINT7_W {
        PCINT7_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Pin Change Enable Mask 0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [pcmsk0](index.html) module"]
pub struct PCMSK0_SPEC;
impl crate::RegisterSpec for PCMSK0_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [pcmsk0::R](R) reader structure"]
impl crate::Readable for PCMSK0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [pcmsk0::W](W) writer structure"]
impl crate::Writable for PCMSK0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PCMSK0 to value 0"]
impl crate::Resettable for PCMSK0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
