#[doc = "Register `ADMUXA` reader"]
pub struct R(crate::R<ADMUXA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ADMUXA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<ADMUXA_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<ADMUXA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `ADMUXA` writer"]
pub struct W(crate::W<ADMUXA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<ADMUXA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<ADMUXA_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<ADMUXA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `MUX` reader - Analog Channel and Gain Selection Bits"]
pub struct MUX_R(crate::FieldReader<u8, u8>);
impl MUX_R {
    pub(crate) fn new(bits: u8) -> Self {
        MUX_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MUX_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MUX` writer - Analog Channel and Gain Selection Bits"]
pub struct MUX_W<'a> {
    w: &'a mut W,
}
impl<'a> MUX_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x3f) | (value as u8 & 0x3f);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:5 - Analog Channel and Gain Selection Bits"]
    #[inline(always)]
    pub fn mux(&self) -> MUX_R {
        MUX_R::new((self.bits & 0x3f) as u8)
    }
}
impl W {
    #[doc = "Bits 0:5 - Analog Channel and Gain Selection Bits"]
    #[inline(always)]
    pub fn mux(&mut self) -> MUX_W {
        MUX_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "The ADC multiplexer Selection Register A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [admuxa](index.html) module"]
pub struct ADMUXA_SPEC;
impl crate::RegisterSpec for ADMUXA_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [admuxa::R](R) reader structure"]
impl crate::Readable for ADMUXA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [admuxa::W](W) writer structure"]
impl crate::Writable for ADMUXA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets ADMUXA to value 0"]
impl crate::Resettable for ADMUXA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
