#[doc = "Register `ACSR0A` reader"]
pub struct R(crate::R<ACSR0A_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ACSR0A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<ACSR0A_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<ACSR0A_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `ACSR0A` writer"]
pub struct W(crate::W<ACSR0A_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<ACSR0A_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<ACSR0A_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<ACSR0A_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Analog Comparator Interrupt Mode Select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum ACIS0_A {
    #[doc = "0: Interrupt on Toggle"]
    ON_TOGGLE = 0,
    #[doc = "2: Interrupt on Falling Edge"]
    ON_FALLING_EDGE = 2,
    #[doc = "3: Interrupt on Rising Edge"]
    ON_RISING_EDGE = 3,
}
impl From<ACIS0_A> for u8 {
    #[inline(always)]
    fn from(variant: ACIS0_A) -> Self {
        variant as _
    }
}
#[doc = "Field `ACIS0` reader - Analog Comparator Interrupt Mode Select"]
pub struct ACIS0_R(crate::FieldReader<u8, ACIS0_A>);
impl ACIS0_R {
    pub(crate) fn new(bits: u8) -> Self {
        ACIS0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<ACIS0_A> {
        match self.bits {
            0 => Some(ACIS0_A::ON_TOGGLE),
            2 => Some(ACIS0_A::ON_FALLING_EDGE),
            3 => Some(ACIS0_A::ON_RISING_EDGE),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `ON_TOGGLE`"]
    #[inline(always)]
    pub fn is_on_toggle(&self) -> bool {
        **self == ACIS0_A::ON_TOGGLE
    }
    #[doc = "Checks if the value of the field is `ON_FALLING_EDGE`"]
    #[inline(always)]
    pub fn is_on_falling_edge(&self) -> bool {
        **self == ACIS0_A::ON_FALLING_EDGE
    }
    #[doc = "Checks if the value of the field is `ON_RISING_EDGE`"]
    #[inline(always)]
    pub fn is_on_rising_edge(&self) -> bool {
        **self == ACIS0_A::ON_RISING_EDGE
    }
}
impl core::ops::Deref for ACIS0_R {
    type Target = crate::FieldReader<u8, ACIS0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACIS0` writer - Analog Comparator Interrupt Mode Select"]
pub struct ACIS0_W<'a> {
    w: &'a mut W,
}
impl<'a> ACIS0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: ACIS0_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Interrupt on Toggle"]
    #[inline(always)]
    pub fn on_toggle(self) -> &'a mut W {
        self.variant(ACIS0_A::ON_TOGGLE)
    }
    #[doc = "Interrupt on Falling Edge"]
    #[inline(always)]
    pub fn on_falling_edge(self) -> &'a mut W {
        self.variant(ACIS0_A::ON_FALLING_EDGE)
    }
    #[doc = "Interrupt on Rising Edge"]
    #[inline(always)]
    pub fn on_rising_edge(self) -> &'a mut W {
        self.variant(ACIS0_A::ON_RISING_EDGE)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Field `ACIC0` reader - Analog Comparator 0 Input Capture Enable"]
pub struct ACIC0_R(crate::FieldReader<bool, bool>);
impl ACIC0_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACIC0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACIC0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACIC0` writer - Analog Comparator 0 Input Capture Enable"]
pub struct ACIC0_W<'a> {
    w: &'a mut W,
}
impl<'a> ACIC0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `ACIE0` reader - Analog Comparator 0 Interrupt Enable"]
pub struct ACIE0_R(crate::FieldReader<bool, bool>);
impl ACIE0_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACIE0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACIE0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACIE0` writer - Analog Comparator 0 Interrupt Enable"]
pub struct ACIE0_W<'a> {
    w: &'a mut W,
}
impl<'a> ACIE0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `ACI0` reader - Analog Comparator 0 Interrupt Flag"]
pub struct ACI0_R(crate::FieldReader<bool, bool>);
impl ACI0_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACI0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACI0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACI0` writer - Analog Comparator 0 Interrupt Flag"]
pub struct ACI0_W<'a> {
    w: &'a mut W,
}
impl<'a> ACI0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `ACO0` reader - Analog Comparator 0 Output"]
pub struct ACO0_R(crate::FieldReader<bool, bool>);
impl ACO0_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACO0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACO0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACO0` writer - Analog Comparator 0 Output"]
pub struct ACO0_W<'a> {
    w: &'a mut W,
}
impl<'a> ACO0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `ACPMUX2` reader - Analog Comparator 0 Positive Input Multiplexer Bit 2"]
pub struct ACPMUX2_R(crate::FieldReader<bool, bool>);
impl ACPMUX2_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACPMUX2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACPMUX2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACPMUX2` writer - Analog Comparator 0 Positive Input Multiplexer Bit 2"]
pub struct ACPMUX2_W<'a> {
    w: &'a mut W,
}
impl<'a> ACPMUX2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `ACD0` reader - Analog Comparator 0 Disable"]
pub struct ACD0_R(crate::FieldReader<bool, bool>);
impl ACD0_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACD0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ACD0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACD0` writer - Analog Comparator 0 Disable"]
pub struct ACD0_W<'a> {
    w: &'a mut W,
}
impl<'a> ACD0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Analog Comparator Interrupt Mode Select"]
    #[inline(always)]
    pub fn acis0(&self) -> ACIS0_R {
        ACIS0_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bit 2 - Analog Comparator 0 Input Capture Enable"]
    #[inline(always)]
    pub fn acic0(&self) -> ACIC0_R {
        ACIC0_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Analog Comparator 0 Interrupt Enable"]
    #[inline(always)]
    pub fn acie0(&self) -> ACIE0_R {
        ACIE0_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Analog Comparator 0 Interrupt Flag"]
    #[inline(always)]
    pub fn aci0(&self) -> ACI0_R {
        ACI0_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Analog Comparator 0 Output"]
    #[inline(always)]
    pub fn aco0(&self) -> ACO0_R {
        ACO0_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Analog Comparator 0 Positive Input Multiplexer Bit 2"]
    #[inline(always)]
    pub fn acpmux2(&self) -> ACPMUX2_R {
        ACPMUX2_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Analog Comparator 0 Disable"]
    #[inline(always)]
    pub fn acd0(&self) -> ACD0_R {
        ACD0_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - Analog Comparator Interrupt Mode Select"]
    #[inline(always)]
    pub fn acis0(&mut self) -> ACIS0_W {
        ACIS0_W { w: self }
    }
    #[doc = "Bit 2 - Analog Comparator 0 Input Capture Enable"]
    #[inline(always)]
    pub fn acic0(&mut self) -> ACIC0_W {
        ACIC0_W { w: self }
    }
    #[doc = "Bit 3 - Analog Comparator 0 Interrupt Enable"]
    #[inline(always)]
    pub fn acie0(&mut self) -> ACIE0_W {
        ACIE0_W { w: self }
    }
    #[doc = "Bit 4 - Analog Comparator 0 Interrupt Flag"]
    #[inline(always)]
    pub fn aci0(&mut self) -> ACI0_W {
        ACI0_W { w: self }
    }
    #[doc = "Bit 5 - Analog Comparator 0 Output"]
    #[inline(always)]
    pub fn aco0(&mut self) -> ACO0_W {
        ACO0_W { w: self }
    }
    #[doc = "Bit 6 - Analog Comparator 0 Positive Input Multiplexer Bit 2"]
    #[inline(always)]
    pub fn acpmux2(&mut self) -> ACPMUX2_W {
        ACPMUX2_W { w: self }
    }
    #[doc = "Bit 7 - Analog Comparator 0 Disable"]
    #[inline(always)]
    pub fn acd0(&mut self) -> ACD0_W {
        ACD0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Analog Comparator 0 Control And Status Register A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [acsr0a](index.html) module"]
pub struct ACSR0A_SPEC;
impl crate::RegisterSpec for ACSR0A_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [acsr0a::R](R) reader structure"]
impl crate::Readable for ACSR0A_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [acsr0a::W](W) writer structure"]
impl crate::Writable for ACSR0A_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets ACSR0A to value 0"]
impl crate::Resettable for ACSR0A_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
