#[doc = "Register `TIFR0` reader"]
pub struct R(crate::R<TIFR0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TIFR0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TIFR0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TIFR0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TIFR0` writer"]
pub struct W(crate::W<TIFR0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TIFR0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TIFR0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TIFR0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TOV0` reader - Timer/Counter0 Overflow Flag"]
pub struct TOV0_R(crate::FieldReader<bool, bool>);
impl TOV0_R {
    pub(crate) fn new(bits: bool) -> Self {
        TOV0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TOV0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TOV0` writer - Timer/Counter0 Overflow Flag"]
pub struct TOV0_W<'a> {
    w: &'a mut W,
}
impl<'a> TOV0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `OCF0A` reader - Timer/Counter0 Output Compare Flag A"]
pub struct OCF0A_R(crate::FieldReader<bool, bool>);
impl OCF0A_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCF0A_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCF0A_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCF0A` writer - Timer/Counter0 Output Compare Flag A"]
pub struct OCF0A_W<'a> {
    w: &'a mut W,
}
impl<'a> OCF0A_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `OCF0B` reader - Timer/Counter0 Output Compare Flag B"]
pub struct OCF0B_R(crate::FieldReader<bool, bool>);
impl OCF0B_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCF0B_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCF0B_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCF0B` writer - Timer/Counter0 Output Compare Flag B"]
pub struct OCF0B_W<'a> {
    w: &'a mut W,
}
impl<'a> OCF0B_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Timer/Counter0 Overflow Flag"]
    #[inline(always)]
    pub fn tov0(&self) -> TOV0_R {
        TOV0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Timer/Counter0 Output Compare Flag A"]
    #[inline(always)]
    pub fn ocf0a(&self) -> OCF0A_R {
        OCF0A_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Timer/Counter0 Output Compare Flag B"]
    #[inline(always)]
    pub fn ocf0b(&self) -> OCF0B_R {
        OCF0B_R::new(((self.bits >> 2) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Timer/Counter0 Overflow Flag"]
    #[inline(always)]
    pub fn tov0(&mut self) -> TOV0_W {
        TOV0_W { w: self }
    }
    #[doc = "Bit 1 - Timer/Counter0 Output Compare Flag A"]
    #[inline(always)]
    pub fn ocf0a(&mut self) -> OCF0A_W {
        OCF0A_W { w: self }
    }
    #[doc = "Bit 2 - Timer/Counter0 Output Compare Flag B"]
    #[inline(always)]
    pub fn ocf0b(&mut self) -> OCF0B_W {
        OCF0B_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Timer/Counter0 Interrupt Flag Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tifr0](index.html) module"]
pub struct TIFR0_SPEC;
impl crate::RegisterSpec for TIFR0_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tifr0::R](R) reader structure"]
impl crate::Readable for TIFR0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tifr0::W](W) writer structure"]
impl crate::Writable for TIFR0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TIFR0 to value 0"]
impl crate::Resettable for TIFR0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
