#[doc = "Register `MSTATUS` reader"]
pub struct R(crate::R<MSTATUS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<MSTATUS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<MSTATUS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<MSTATUS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `MSTATUS` writer"]
pub struct W(crate::W<MSTATUS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<MSTATUS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<MSTATUS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<MSTATUS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Bus State\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum BUSSTATE_A {
    #[doc = "0: Unknown Bus State"]
    UNKNOWN = 0,
    #[doc = "1: Bus is Idle"]
    IDLE = 1,
    #[doc = "2: This Module Controls The Bus"]
    OWNER = 2,
    #[doc = "3: The Bus is Busy"]
    BUSY = 3,
}
impl From<BUSSTATE_A> for u8 {
    #[inline(always)]
    fn from(variant: BUSSTATE_A) -> Self {
        variant as _
    }
}
#[doc = "Field `BUSSTATE` reader - Bus State"]
pub struct BUSSTATE_R(crate::FieldReader<u8, BUSSTATE_A>);
impl BUSSTATE_R {
    pub(crate) fn new(bits: u8) -> Self {
        BUSSTATE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> BUSSTATE_A {
        match self.bits {
            0 => BUSSTATE_A::UNKNOWN,
            1 => BUSSTATE_A::IDLE,
            2 => BUSSTATE_A::OWNER,
            3 => BUSSTATE_A::BUSY,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `UNKNOWN`"]
    #[inline(always)]
    pub fn is_unknown(&self) -> bool {
        **self == BUSSTATE_A::UNKNOWN
    }
    #[doc = "Checks if the value of the field is `IDLE`"]
    #[inline(always)]
    pub fn is_idle(&self) -> bool {
        **self == BUSSTATE_A::IDLE
    }
    #[doc = "Checks if the value of the field is `OWNER`"]
    #[inline(always)]
    pub fn is_owner(&self) -> bool {
        **self == BUSSTATE_A::OWNER
    }
    #[doc = "Checks if the value of the field is `BUSY`"]
    #[inline(always)]
    pub fn is_busy(&self) -> bool {
        **self == BUSSTATE_A::BUSY
    }
}
impl core::ops::Deref for BUSSTATE_R {
    type Target = crate::FieldReader<u8, BUSSTATE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BUSSTATE` writer - Bus State"]
pub struct BUSSTATE_W<'a> {
    w: &'a mut W,
}
impl<'a> BUSSTATE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: BUSSTATE_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Unknown Bus State"]
    #[inline(always)]
    pub fn unknown(self) -> &'a mut W {
        self.variant(BUSSTATE_A::UNKNOWN)
    }
    #[doc = "Bus is Idle"]
    #[inline(always)]
    pub fn idle(self) -> &'a mut W {
        self.variant(BUSSTATE_A::IDLE)
    }
    #[doc = "This Module Controls The Bus"]
    #[inline(always)]
    pub fn owner(self) -> &'a mut W {
        self.variant(BUSSTATE_A::OWNER)
    }
    #[doc = "The Bus is Busy"]
    #[inline(always)]
    pub fn busy(self) -> &'a mut W {
        self.variant(BUSSTATE_A::BUSY)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Field `BUSERR` reader - Bus Error"]
pub struct BUSERR_R(crate::FieldReader<bool, bool>);
impl BUSERR_R {
    pub(crate) fn new(bits: bool) -> Self {
        BUSERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BUSERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BUSERR` writer - Bus Error"]
pub struct BUSERR_W<'a> {
    w: &'a mut W,
}
impl<'a> BUSERR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `ARBLOST` reader - Arbitration Lost"]
pub struct ARBLOST_R(crate::FieldReader<bool, bool>);
impl ARBLOST_R {
    pub(crate) fn new(bits: bool) -> Self {
        ARBLOST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ARBLOST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ARBLOST` writer - Arbitration Lost"]
pub struct ARBLOST_W<'a> {
    w: &'a mut W,
}
impl<'a> ARBLOST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `RXACK` reader - Received Acknowledge"]
pub struct RXACK_R(crate::FieldReader<bool, bool>);
impl RXACK_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXACK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXACK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CLKHOLD` reader - Clock Hold"]
pub struct CLKHOLD_R(crate::FieldReader<bool, bool>);
impl CLKHOLD_R {
    pub(crate) fn new(bits: bool) -> Self {
        CLKHOLD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CLKHOLD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CLKHOLD` writer - Clock Hold"]
pub struct CLKHOLD_W<'a> {
    w: &'a mut W,
}
impl<'a> CLKHOLD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `WIF` reader - Write Interrupt Flag"]
pub struct WIF_R(crate::FieldReader<bool, bool>);
impl WIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        WIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WIF` writer - Write Interrupt Flag"]
pub struct WIF_W<'a> {
    w: &'a mut W,
}
impl<'a> WIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `RIF` reader - Read Interrupt Flag"]
pub struct RIF_R(crate::FieldReader<bool, bool>);
impl RIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        RIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RIF` writer - Read Interrupt Flag"]
pub struct RIF_W<'a> {
    w: &'a mut W,
}
impl<'a> RIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Bus State"]
    #[inline(always)]
    pub fn busstate(&self) -> BUSSTATE_R {
        BUSSTATE_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bit 2 - Bus Error"]
    #[inline(always)]
    pub fn buserr(&self) -> BUSERR_R {
        BUSERR_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Arbitration Lost"]
    #[inline(always)]
    pub fn arblost(&self) -> ARBLOST_R {
        ARBLOST_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Received Acknowledge"]
    #[inline(always)]
    pub fn rxack(&self) -> RXACK_R {
        RXACK_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Clock Hold"]
    #[inline(always)]
    pub fn clkhold(&self) -> CLKHOLD_R {
        CLKHOLD_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Write Interrupt Flag"]
    #[inline(always)]
    pub fn wif(&self) -> WIF_R {
        WIF_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Read Interrupt Flag"]
    #[inline(always)]
    pub fn rif(&self) -> RIF_R {
        RIF_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - Bus State"]
    #[inline(always)]
    pub fn busstate(&mut self) -> BUSSTATE_W {
        BUSSTATE_W { w: self }
    }
    #[doc = "Bit 2 - Bus Error"]
    #[inline(always)]
    pub fn buserr(&mut self) -> BUSERR_W {
        BUSERR_W { w: self }
    }
    #[doc = "Bit 3 - Arbitration Lost"]
    #[inline(always)]
    pub fn arblost(&mut self) -> ARBLOST_W {
        ARBLOST_W { w: self }
    }
    #[doc = "Bit 5 - Clock Hold"]
    #[inline(always)]
    pub fn clkhold(&mut self) -> CLKHOLD_W {
        CLKHOLD_W { w: self }
    }
    #[doc = "Bit 6 - Write Interrupt Flag"]
    #[inline(always)]
    pub fn wif(&mut self) -> WIF_W {
        WIF_W { w: self }
    }
    #[doc = "Bit 7 - Read Interrupt Flag"]
    #[inline(always)]
    pub fn rif(&mut self) -> RIF_W {
        RIF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Master Status\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [mstatus](index.html) module"]
pub struct MSTATUS_SPEC;
impl crate::RegisterSpec for MSTATUS_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [mstatus::R](R) reader structure"]
impl crate::Readable for MSTATUS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [mstatus::W](W) writer structure"]
impl crate::Writable for MSTATUS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets MSTATUS to value 0"]
impl crate::Resettable for MSTATUS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
