#[doc = "Register `EVCTRLB` reader"]
pub struct R(crate::R<EVCTRLB_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<EVCTRLB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<EVCTRLB_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<EVCTRLB_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `EVCTRLB` writer"]
pub struct W(crate::W<EVCTRLB_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<EVCTRLB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<EVCTRLB_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<EVCTRLB_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TRIGEI` reader - Trigger event enable"]
pub struct TRIGEI_R(crate::FieldReader<bool, bool>);
impl TRIGEI_R {
    pub(crate) fn new(bits: bool) -> Self {
        TRIGEI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TRIGEI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TRIGEI` writer - Trigger event enable"]
pub struct TRIGEI_W<'a> {
    w: &'a mut W,
}
impl<'a> TRIGEI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "event action\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum ACTION_A {
    #[doc = "0: Event trigger a fault"]
    FAULT = 0,
    #[doc = "1: Event trigger a fault and capture"]
    CAPTURE = 1,
}
impl From<ACTION_A> for bool {
    #[inline(always)]
    fn from(variant: ACTION_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `ACTION` reader - event action"]
pub struct ACTION_R(crate::FieldReader<bool, ACTION_A>);
impl ACTION_R {
    pub(crate) fn new(bits: bool) -> Self {
        ACTION_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> ACTION_A {
        match self.bits {
            false => ACTION_A::FAULT,
            true => ACTION_A::CAPTURE,
        }
    }
    #[doc = "Checks if the value of the field is `FAULT`"]
    #[inline(always)]
    pub fn is_fault(&self) -> bool {
        **self == ACTION_A::FAULT
    }
    #[doc = "Checks if the value of the field is `CAPTURE`"]
    #[inline(always)]
    pub fn is_capture(&self) -> bool {
        **self == ACTION_A::CAPTURE
    }
}
impl core::ops::Deref for ACTION_R {
    type Target = crate::FieldReader<bool, ACTION_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ACTION` writer - event action"]
pub struct ACTION_W<'a> {
    w: &'a mut W,
}
impl<'a> ACTION_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: ACTION_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event trigger a fault"]
    #[inline(always)]
    pub fn fault(self) -> &'a mut W {
        self.variant(ACTION_A::FAULT)
    }
    #[doc = "Event trigger a fault and capture"]
    #[inline(always)]
    pub fn capture(self) -> &'a mut W {
        self.variant(ACTION_A::CAPTURE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "edge select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum EDGE_A {
    #[doc = "0: The falling edge or low level of event generates retrigger or fault action"]
    FALL_LOW = 0,
    #[doc = "1: The rising edge or high level of event generates retrigger or fault action"]
    RISE_HIGH = 1,
}
impl From<EDGE_A> for bool {
    #[inline(always)]
    fn from(variant: EDGE_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `EDGE` reader - edge select"]
pub struct EDGE_R(crate::FieldReader<bool, EDGE_A>);
impl EDGE_R {
    pub(crate) fn new(bits: bool) -> Self {
        EDGE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> EDGE_A {
        match self.bits {
            false => EDGE_A::FALL_LOW,
            true => EDGE_A::RISE_HIGH,
        }
    }
    #[doc = "Checks if the value of the field is `FALL_LOW`"]
    #[inline(always)]
    pub fn is_fall_low(&self) -> bool {
        **self == EDGE_A::FALL_LOW
    }
    #[doc = "Checks if the value of the field is `RISE_HIGH`"]
    #[inline(always)]
    pub fn is_rise_high(&self) -> bool {
        **self == EDGE_A::RISE_HIGH
    }
}
impl core::ops::Deref for EDGE_R {
    type Target = crate::FieldReader<bool, EDGE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EDGE` writer - edge select"]
pub struct EDGE_W<'a> {
    w: &'a mut W,
}
impl<'a> EDGE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EDGE_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "The falling edge or low level of event generates retrigger or fault action"]
    #[inline(always)]
    pub fn fall_low(self) -> &'a mut W {
        self.variant(EDGE_A::FALL_LOW)
    }
    #[doc = "The rising edge or high level of event generates retrigger or fault action"]
    #[inline(always)]
    pub fn rise_high(self) -> &'a mut W {
        self.variant(EDGE_A::RISE_HIGH)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "event config\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CFG_A {
    #[doc = "0: Neither Filter nor Asynchronous Event is enabled"]
    NEITHER = 0,
    #[doc = "1: Input Capture Noise Cancellation Filter enabled"]
    FILTERON = 1,
    #[doc = "2: Asynchronous Event output qualification enabled"]
    ASYNCON = 2,
}
impl From<CFG_A> for u8 {
    #[inline(always)]
    fn from(variant: CFG_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CFG` reader - event config"]
pub struct CFG_R(crate::FieldReader<u8, CFG_A>);
impl CFG_R {
    pub(crate) fn new(bits: u8) -> Self {
        CFG_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<CFG_A> {
        match self.bits {
            0 => Some(CFG_A::NEITHER),
            1 => Some(CFG_A::FILTERON),
            2 => Some(CFG_A::ASYNCON),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `NEITHER`"]
    #[inline(always)]
    pub fn is_neither(&self) -> bool {
        **self == CFG_A::NEITHER
    }
    #[doc = "Checks if the value of the field is `FILTERON`"]
    #[inline(always)]
    pub fn is_filteron(&self) -> bool {
        **self == CFG_A::FILTERON
    }
    #[doc = "Checks if the value of the field is `ASYNCON`"]
    #[inline(always)]
    pub fn is_asyncon(&self) -> bool {
        **self == CFG_A::ASYNCON
    }
}
impl core::ops::Deref for CFG_R {
    type Target = crate::FieldReader<u8, CFG_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CFG` writer - event config"]
pub struct CFG_W<'a> {
    w: &'a mut W,
}
impl<'a> CFG_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CFG_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Neither Filter nor Asynchronous Event is enabled"]
    #[inline(always)]
    pub fn neither(self) -> &'a mut W {
        self.variant(CFG_A::NEITHER)
    }
    #[doc = "Input Capture Noise Cancellation Filter enabled"]
    #[inline(always)]
    pub fn filteron(self) -> &'a mut W {
        self.variant(CFG_A::FILTERON)
    }
    #[doc = "Asynchronous Event output qualification enabled"]
    #[inline(always)]
    pub fn asyncon(self) -> &'a mut W {
        self.variant(CFG_A::ASYNCON)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Trigger event enable"]
    #[inline(always)]
    pub fn trigei(&self) -> TRIGEI_R {
        TRIGEI_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 2 - event action"]
    #[inline(always)]
    pub fn action(&self) -> ACTION_R {
        ACTION_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 4 - edge select"]
    #[inline(always)]
    pub fn edge(&self) -> EDGE_R {
        EDGE_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bits 6:7 - event config"]
    #[inline(always)]
    pub fn cfg(&self) -> CFG_R {
        CFG_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bit 0 - Trigger event enable"]
    #[inline(always)]
    pub fn trigei(&mut self) -> TRIGEI_W {
        TRIGEI_W { w: self }
    }
    #[doc = "Bit 2 - event action"]
    #[inline(always)]
    pub fn action(&mut self) -> ACTION_W {
        ACTION_W { w: self }
    }
    #[doc = "Bit 4 - edge select"]
    #[inline(always)]
    pub fn edge(&mut self) -> EDGE_W {
        EDGE_W { w: self }
    }
    #[doc = "Bits 6:7 - event config"]
    #[inline(always)]
    pub fn cfg(&mut self) -> CFG_W {
        CFG_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "EVCTRLB\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [evctrlb](index.html) module"]
pub struct EVCTRLB_SPEC;
impl crate::RegisterSpec for EVCTRLB_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [evctrlb::R](R) reader structure"]
impl crate::Readable for EVCTRLB_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [evctrlb::W](W) writer structure"]
impl crate::Writable for EVCTRLB_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets EVCTRLB to value 0"]
impl crate::Resettable for EVCTRLB_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
