#[doc = "Register `CTRLE` reader"]
pub struct R(crate::R<CTRLE_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CTRLE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CTRLE_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CTRLE_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CTRLE` writer"]
pub struct W(crate::W<CTRLE_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CTRLE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CTRLE_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CTRLE_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SYNCEOC` reader - synchronize end of cycle strobe"]
pub struct SYNCEOC_R(crate::FieldReader<bool, bool>);
impl SYNCEOC_R {
    pub(crate) fn new(bits: bool) -> Self {
        SYNCEOC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SYNCEOC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SYNCEOC` writer - synchronize end of cycle strobe"]
pub struct SYNCEOC_W<'a> {
    w: &'a mut W,
}
impl<'a> SYNCEOC_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `SYNC` reader - synchronize strobe"]
pub struct SYNC_R(crate::FieldReader<bool, bool>);
impl SYNC_R {
    pub(crate) fn new(bits: bool) -> Self {
        SYNC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SYNC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SYNC` writer - synchronize strobe"]
pub struct SYNC_W<'a> {
    w: &'a mut W,
}
impl<'a> SYNC_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `RESTART` reader - Restart strobe"]
pub struct RESTART_R(crate::FieldReader<bool, bool>);
impl RESTART_R {
    pub(crate) fn new(bits: bool) -> Self {
        RESTART_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RESTART_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RESTART` writer - Restart strobe"]
pub struct RESTART_W<'a> {
    w: &'a mut W,
}
impl<'a> RESTART_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `SCAPTUREA` reader - Software Capture A Strobe"]
pub struct SCAPTUREA_R(crate::FieldReader<bool, bool>);
impl SCAPTUREA_R {
    pub(crate) fn new(bits: bool) -> Self {
        SCAPTUREA_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SCAPTUREA_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SCAPTUREA` writer - Software Capture A Strobe"]
pub struct SCAPTUREA_W<'a> {
    w: &'a mut W,
}
impl<'a> SCAPTUREA_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `SCAPTUREB` reader - Software Capture B Strobe"]
pub struct SCAPTUREB_R(crate::FieldReader<bool, bool>);
impl SCAPTUREB_R {
    pub(crate) fn new(bits: bool) -> Self {
        SCAPTUREB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SCAPTUREB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SCAPTUREB` writer - Software Capture B Strobe"]
pub struct SCAPTUREB_W<'a> {
    w: &'a mut W,
}
impl<'a> SCAPTUREB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `DISEOC` reader - Disable at end of cycle"]
pub struct DISEOC_R(crate::FieldReader<bool, bool>);
impl DISEOC_R {
    pub(crate) fn new(bits: bool) -> Self {
        DISEOC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DISEOC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DISEOC` writer - Disable at end of cycle"]
pub struct DISEOC_W<'a> {
    w: &'a mut W,
}
impl<'a> DISEOC_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - synchronize end of cycle strobe"]
    #[inline(always)]
    pub fn synceoc(&self) -> SYNCEOC_R {
        SYNCEOC_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - synchronize strobe"]
    #[inline(always)]
    pub fn sync(&self) -> SYNC_R {
        SYNC_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Restart strobe"]
    #[inline(always)]
    pub fn restart(&self) -> RESTART_R {
        RESTART_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Software Capture A Strobe"]
    #[inline(always)]
    pub fn scapturea(&self) -> SCAPTUREA_R {
        SCAPTUREA_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Software Capture B Strobe"]
    #[inline(always)]
    pub fn scaptureb(&self) -> SCAPTUREB_R {
        SCAPTUREB_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Disable at end of cycle"]
    #[inline(always)]
    pub fn diseoc(&self) -> DISEOC_R {
        DISEOC_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - synchronize end of cycle strobe"]
    #[inline(always)]
    pub fn synceoc(&mut self) -> SYNCEOC_W {
        SYNCEOC_W { w: self }
    }
    #[doc = "Bit 1 - synchronize strobe"]
    #[inline(always)]
    pub fn sync(&mut self) -> SYNC_W {
        SYNC_W { w: self }
    }
    #[doc = "Bit 2 - Restart strobe"]
    #[inline(always)]
    pub fn restart(&mut self) -> RESTART_W {
        RESTART_W { w: self }
    }
    #[doc = "Bit 3 - Software Capture A Strobe"]
    #[inline(always)]
    pub fn scapturea(&mut self) -> SCAPTUREA_W {
        SCAPTUREA_W { w: self }
    }
    #[doc = "Bit 4 - Software Capture B Strobe"]
    #[inline(always)]
    pub fn scaptureb(&mut self) -> SCAPTUREB_W {
        SCAPTUREB_W { w: self }
    }
    #[doc = "Bit 7 - Disable at end of cycle"]
    #[inline(always)]
    pub fn diseoc(&mut self) -> DISEOC_W {
        DISEOC_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Control E\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ctrle](index.html) module"]
pub struct CTRLE_SPEC;
impl crate::RegisterSpec for CTRLE_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ctrle::R](R) reader structure"]
impl crate::Readable for CTRLE_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ctrle::W](W) writer structure"]
impl crate::Writable for CTRLE_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CTRLE to value 0"]
impl crate::Resettable for CTRLE_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
