#[doc = "Register `CTRLC` reader"]
pub struct R(crate::R<CTRLC_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CTRLC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CTRLC_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CTRLC_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CTRLC` writer"]
pub struct W(crate::W<CTRLC_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CTRLC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CTRLC_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CTRLC_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `CMPOVR` reader - Compare output value override"]
pub struct CMPOVR_R(crate::FieldReader<bool, bool>);
impl CMPOVR_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMPOVR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMPOVR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMPOVR` writer - Compare output value override"]
pub struct CMPOVR_W<'a> {
    w: &'a mut W,
}
impl<'a> CMPOVR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `AUPDATE` reader - Auto update"]
pub struct AUPDATE_R(crate::FieldReader<bool, bool>);
impl AUPDATE_R {
    pub(crate) fn new(bits: bool) -> Self {
        AUPDATE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AUPDATE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AUPDATE` writer - Auto update"]
pub struct AUPDATE_W<'a> {
    w: &'a mut W,
}
impl<'a> AUPDATE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `FIFTY` reader - Fifty percent waveform"]
pub struct FIFTY_R(crate::FieldReader<bool, bool>);
impl FIFTY_R {
    pub(crate) fn new(bits: bool) -> Self {
        FIFTY_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FIFTY_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FIFTY` writer - Fifty percent waveform"]
pub struct FIFTY_W<'a> {
    w: &'a mut W,
}
impl<'a> FIFTY_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Compare C output select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum CMPCSEL_A {
    #[doc = "0: PWM A output"]
    PWMA = 0,
    #[doc = "1: PWM B output"]
    PWMB = 1,
}
impl From<CMPCSEL_A> for bool {
    #[inline(always)]
    fn from(variant: CMPCSEL_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `CMPCSEL` reader - Compare C output select"]
pub struct CMPCSEL_R(crate::FieldReader<bool, CMPCSEL_A>);
impl CMPCSEL_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMPCSEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CMPCSEL_A {
        match self.bits {
            false => CMPCSEL_A::PWMA,
            true => CMPCSEL_A::PWMB,
        }
    }
    #[doc = "Checks if the value of the field is `PWMA`"]
    #[inline(always)]
    pub fn is_pwma(&self) -> bool {
        **self == CMPCSEL_A::PWMA
    }
    #[doc = "Checks if the value of the field is `PWMB`"]
    #[inline(always)]
    pub fn is_pwmb(&self) -> bool {
        **self == CMPCSEL_A::PWMB
    }
}
impl core::ops::Deref for CMPCSEL_R {
    type Target = crate::FieldReader<bool, CMPCSEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMPCSEL` writer - Compare C output select"]
pub struct CMPCSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> CMPCSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CMPCSEL_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "PWM A output"]
    #[inline(always)]
    pub fn pwma(self) -> &'a mut W {
        self.variant(CMPCSEL_A::PWMA)
    }
    #[doc = "PWM B output"]
    #[inline(always)]
    pub fn pwmb(self) -> &'a mut W {
        self.variant(CMPCSEL_A::PWMB)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Compare D output select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum CMPDSEL_A {
    #[doc = "0: PWM A output"]
    PWMA = 0,
    #[doc = "1: PWM B output"]
    PWMB = 1,
}
impl From<CMPDSEL_A> for bool {
    #[inline(always)]
    fn from(variant: CMPDSEL_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `CMPDSEL` reader - Compare D output select"]
pub struct CMPDSEL_R(crate::FieldReader<bool, CMPDSEL_A>);
impl CMPDSEL_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMPDSEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CMPDSEL_A {
        match self.bits {
            false => CMPDSEL_A::PWMA,
            true => CMPDSEL_A::PWMB,
        }
    }
    #[doc = "Checks if the value of the field is `PWMA`"]
    #[inline(always)]
    pub fn is_pwma(&self) -> bool {
        **self == CMPDSEL_A::PWMA
    }
    #[doc = "Checks if the value of the field is `PWMB`"]
    #[inline(always)]
    pub fn is_pwmb(&self) -> bool {
        **self == CMPDSEL_A::PWMB
    }
}
impl core::ops::Deref for CMPDSEL_R {
    type Target = crate::FieldReader<bool, CMPDSEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMPDSEL` writer - Compare D output select"]
pub struct CMPDSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> CMPDSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CMPDSEL_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "PWM A output"]
    #[inline(always)]
    pub fn pwma(self) -> &'a mut W {
        self.variant(CMPDSEL_A::PWMA)
    }
    #[doc = "PWM B output"]
    #[inline(always)]
    pub fn pwmb(self) -> &'a mut W {
        self.variant(CMPDSEL_A::PWMB)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Compare output value override"]
    #[inline(always)]
    pub fn cmpovr(&self) -> CMPOVR_R {
        CMPOVR_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Auto update"]
    #[inline(always)]
    pub fn aupdate(&self) -> AUPDATE_R {
        AUPDATE_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Fifty percent waveform"]
    #[inline(always)]
    pub fn fifty(&self) -> FIFTY_R {
        FIFTY_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Compare C output select"]
    #[inline(always)]
    pub fn cmpcsel(&self) -> CMPCSEL_R {
        CMPCSEL_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Compare D output select"]
    #[inline(always)]
    pub fn cmpdsel(&self) -> CMPDSEL_R {
        CMPDSEL_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Compare output value override"]
    #[inline(always)]
    pub fn cmpovr(&mut self) -> CMPOVR_W {
        CMPOVR_W { w: self }
    }
    #[doc = "Bit 1 - Auto update"]
    #[inline(always)]
    pub fn aupdate(&mut self) -> AUPDATE_W {
        AUPDATE_W { w: self }
    }
    #[doc = "Bit 3 - Fifty percent waveform"]
    #[inline(always)]
    pub fn fifty(&mut self) -> FIFTY_W {
        FIFTY_W { w: self }
    }
    #[doc = "Bit 6 - Compare C output select"]
    #[inline(always)]
    pub fn cmpcsel(&mut self) -> CMPCSEL_W {
        CMPCSEL_W { w: self }
    }
    #[doc = "Bit 7 - Compare D output select"]
    #[inline(always)]
    pub fn cmpdsel(&mut self) -> CMPDSEL_W {
        CMPDSEL_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Control C\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ctrlc](index.html) module"]
pub struct CTRLC_SPEC;
impl crate::RegisterSpec for CTRLC_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ctrlc::R](R) reader structure"]
impl crate::Readable for CTRLC_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ctrlc::W](W) writer structure"]
impl crate::Writable for CTRLC_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CTRLC to value 0"]
impl crate::Resettable for CTRLC_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
