#[doc = "Register `CTRLB` reader"]
pub struct R(crate::R<CTRLB_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CTRLB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CTRLB_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CTRLB_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CTRLB` writer"]
pub struct W(crate::W<CTRLB_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CTRLB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CTRLB_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CTRLB_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Waveform generation mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum WGMODE_A {
    #[doc = "0: One ramp mode"]
    ONERAMP = 0,
    #[doc = "1: Two ramp mode"]
    TWORAMP = 1,
    #[doc = "2: Four ramp mode"]
    FOURRAMP = 2,
    #[doc = "3: Dual slope mode"]
    DS = 3,
}
impl From<WGMODE_A> for u8 {
    #[inline(always)]
    fn from(variant: WGMODE_A) -> Self {
        variant as _
    }
}
#[doc = "Field `WGMODE` reader - Waveform generation mode"]
pub struct WGMODE_R(crate::FieldReader<u8, WGMODE_A>);
impl WGMODE_R {
    pub(crate) fn new(bits: u8) -> Self {
        WGMODE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> WGMODE_A {
        match self.bits {
            0 => WGMODE_A::ONERAMP,
            1 => WGMODE_A::TWORAMP,
            2 => WGMODE_A::FOURRAMP,
            3 => WGMODE_A::DS,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `ONERAMP`"]
    #[inline(always)]
    pub fn is_oneramp(&self) -> bool {
        **self == WGMODE_A::ONERAMP
    }
    #[doc = "Checks if the value of the field is `TWORAMP`"]
    #[inline(always)]
    pub fn is_tworamp(&self) -> bool {
        **self == WGMODE_A::TWORAMP
    }
    #[doc = "Checks if the value of the field is `FOURRAMP`"]
    #[inline(always)]
    pub fn is_fourramp(&self) -> bool {
        **self == WGMODE_A::FOURRAMP
    }
    #[doc = "Checks if the value of the field is `DS`"]
    #[inline(always)]
    pub fn is_ds(&self) -> bool {
        **self == WGMODE_A::DS
    }
}
impl core::ops::Deref for WGMODE_R {
    type Target = crate::FieldReader<u8, WGMODE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WGMODE` writer - Waveform generation mode"]
pub struct WGMODE_W<'a> {
    w: &'a mut W,
}
impl<'a> WGMODE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: WGMODE_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "One ramp mode"]
    #[inline(always)]
    pub fn oneramp(self) -> &'a mut W {
        self.variant(WGMODE_A::ONERAMP)
    }
    #[doc = "Two ramp mode"]
    #[inline(always)]
    pub fn tworamp(self) -> &'a mut W {
        self.variant(WGMODE_A::TWORAMP)
    }
    #[doc = "Four ramp mode"]
    #[inline(always)]
    pub fn fourramp(self) -> &'a mut W {
        self.variant(WGMODE_A::FOURRAMP)
    }
    #[doc = "Dual slope mode"]
    #[inline(always)]
    pub fn ds(self) -> &'a mut W {
        self.variant(WGMODE_A::DS)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - Waveform generation mode"]
    #[inline(always)]
    pub fn wgmode(&self) -> WGMODE_R {
        WGMODE_R::new((self.bits & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 0:1 - Waveform generation mode"]
    #[inline(always)]
    pub fn wgmode(&mut self) -> WGMODE_W {
        WGMODE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Control B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ctrlb](index.html) module"]
pub struct CTRLB_SPEC;
impl crate::RegisterSpec for CTRLB_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ctrlb::R](R) reader structure"]
impl crate::Readable for CTRLB_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ctrlb::W](W) writer structure"]
impl crate::Writable for CTRLB_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CTRLB to value 0"]
impl crate::Resettable for CTRLB_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
