#[doc = "Register `TCD0CFG` reader"]
pub struct R(crate::R<TCD0CFG_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TCD0CFG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TCD0CFG_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TCD0CFG_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TCD0CFG` writer"]
pub struct W(crate::W<TCD0CFG_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TCD0CFG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<TCD0CFG_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<TCD0CFG_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `CMPA` reader - Compare A Default Output Value"]
pub struct CMPA_R(crate::FieldReader<bool, bool>);
impl CMPA_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMPA_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMPA_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMPA` writer - Compare A Default Output Value"]
pub struct CMPA_W<'a> {
    w: &'a mut W,
}
impl<'a> CMPA_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `CMPB` reader - Compare B Default Output Value"]
pub struct CMPB_R(crate::FieldReader<bool, bool>);
impl CMPB_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMPB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMPB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMPB` writer - Compare B Default Output Value"]
pub struct CMPB_W<'a> {
    w: &'a mut W,
}
impl<'a> CMPB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `CMPC` reader - Compare C Default Output Value"]
pub struct CMPC_R(crate::FieldReader<bool, bool>);
impl CMPC_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMPC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMPC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMPC` writer - Compare C Default Output Value"]
pub struct CMPC_W<'a> {
    w: &'a mut W,
}
impl<'a> CMPC_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `CMPD` reader - Compare D Default Output Value"]
pub struct CMPD_R(crate::FieldReader<bool, bool>);
impl CMPD_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMPD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMPD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMPD` writer - Compare D Default Output Value"]
pub struct CMPD_W<'a> {
    w: &'a mut W,
}
impl<'a> CMPD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `CMPAEN` reader - Compare A Output Enable"]
pub struct CMPAEN_R(crate::FieldReader<bool, bool>);
impl CMPAEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMPAEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMPAEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMPAEN` writer - Compare A Output Enable"]
pub struct CMPAEN_W<'a> {
    w: &'a mut W,
}
impl<'a> CMPAEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `CMPBEN` reader - Compare B Output Enable"]
pub struct CMPBEN_R(crate::FieldReader<bool, bool>);
impl CMPBEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMPBEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMPBEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMPBEN` writer - Compare B Output Enable"]
pub struct CMPBEN_W<'a> {
    w: &'a mut W,
}
impl<'a> CMPBEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `CMPCEN` reader - Compare C Output Enable"]
pub struct CMPCEN_R(crate::FieldReader<bool, bool>);
impl CMPCEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMPCEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMPCEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMPCEN` writer - Compare C Output Enable"]
pub struct CMPCEN_W<'a> {
    w: &'a mut W,
}
impl<'a> CMPCEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `CMPDEN` reader - Compare D Output Enable"]
pub struct CMPDEN_R(crate::FieldReader<bool, bool>);
impl CMPDEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMPDEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMPDEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMPDEN` writer - Compare D Output Enable"]
pub struct CMPDEN_W<'a> {
    w: &'a mut W,
}
impl<'a> CMPDEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Compare A Default Output Value"]
    #[inline(always)]
    pub fn cmpa(&self) -> CMPA_R {
        CMPA_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Compare B Default Output Value"]
    #[inline(always)]
    pub fn cmpb(&self) -> CMPB_R {
        CMPB_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Compare C Default Output Value"]
    #[inline(always)]
    pub fn cmpc(&self) -> CMPC_R {
        CMPC_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Compare D Default Output Value"]
    #[inline(always)]
    pub fn cmpd(&self) -> CMPD_R {
        CMPD_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Compare A Output Enable"]
    #[inline(always)]
    pub fn cmpaen(&self) -> CMPAEN_R {
        CMPAEN_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Compare B Output Enable"]
    #[inline(always)]
    pub fn cmpben(&self) -> CMPBEN_R {
        CMPBEN_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Compare C Output Enable"]
    #[inline(always)]
    pub fn cmpcen(&self) -> CMPCEN_R {
        CMPCEN_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Compare D Output Enable"]
    #[inline(always)]
    pub fn cmpden(&self) -> CMPDEN_R {
        CMPDEN_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Compare A Default Output Value"]
    #[inline(always)]
    pub fn cmpa(&mut self) -> CMPA_W {
        CMPA_W { w: self }
    }
    #[doc = "Bit 1 - Compare B Default Output Value"]
    #[inline(always)]
    pub fn cmpb(&mut self) -> CMPB_W {
        CMPB_W { w: self }
    }
    #[doc = "Bit 2 - Compare C Default Output Value"]
    #[inline(always)]
    pub fn cmpc(&mut self) -> CMPC_W {
        CMPC_W { w: self }
    }
    #[doc = "Bit 3 - Compare D Default Output Value"]
    #[inline(always)]
    pub fn cmpd(&mut self) -> CMPD_W {
        CMPD_W { w: self }
    }
    #[doc = "Bit 4 - Compare A Output Enable"]
    #[inline(always)]
    pub fn cmpaen(&mut self) -> CMPAEN_W {
        CMPAEN_W { w: self }
    }
    #[doc = "Bit 5 - Compare B Output Enable"]
    #[inline(always)]
    pub fn cmpben(&mut self) -> CMPBEN_W {
        CMPBEN_W { w: self }
    }
    #[doc = "Bit 6 - Compare C Output Enable"]
    #[inline(always)]
    pub fn cmpcen(&mut self) -> CMPCEN_W {
        CMPCEN_W { w: self }
    }
    #[doc = "Bit 7 - Compare D Output Enable"]
    #[inline(always)]
    pub fn cmpden(&mut self) -> CMPDEN_W {
        CMPDEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "TCD0 Configuration\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tcd0cfg](index.html) module"]
pub struct TCD0CFG_SPEC;
impl crate::RegisterSpec for TCD0CFG_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [tcd0cfg::R](R) reader structure"]
impl crate::Readable for TCD0CFG_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tcd0cfg::W](W) writer structure"]
impl crate::Writable for TCD0CFG_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TCD0CFG to value 0"]
impl crate::Resettable for TCD0CFG_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
