#[doc = "Register `SYNCUSER0` reader"]
pub struct R(crate::R<SYNCUSER0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SYNCUSER0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SYNCUSER0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SYNCUSER0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SYNCUSER0` writer"]
pub struct W(crate::W<SYNCUSER0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SYNCUSER0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SYNCUSER0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SYNCUSER0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Synchronous User Ch 0 Input Selection - TCA0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum SYNCUSER0_A {
    #[doc = "0: Off"]
    OFF = 0,
    #[doc = "1: Synchronous Event Channel 0"]
    SYNCCH0 = 1,
    #[doc = "2: Synchronous Event Channel 1"]
    SYNCCH1 = 2,
}
impl From<SYNCUSER0_A> for u8 {
    #[inline(always)]
    fn from(variant: SYNCUSER0_A) -> Self {
        variant as _
    }
}
#[doc = "Field `SYNCUSER0` reader - Synchronous User Ch 0 Input Selection - TCA0"]
pub struct SYNCUSER0_R(crate::FieldReader<u8, SYNCUSER0_A>);
impl SYNCUSER0_R {
    pub(crate) fn new(bits: u8) -> Self {
        SYNCUSER0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<SYNCUSER0_A> {
        match self.bits {
            0 => Some(SYNCUSER0_A::OFF),
            1 => Some(SYNCUSER0_A::SYNCCH0),
            2 => Some(SYNCUSER0_A::SYNCCH1),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `OFF`"]
    #[inline(always)]
    pub fn is_off(&self) -> bool {
        **self == SYNCUSER0_A::OFF
    }
    #[doc = "Checks if the value of the field is `SYNCCH0`"]
    #[inline(always)]
    pub fn is_syncch0(&self) -> bool {
        **self == SYNCUSER0_A::SYNCCH0
    }
    #[doc = "Checks if the value of the field is `SYNCCH1`"]
    #[inline(always)]
    pub fn is_syncch1(&self) -> bool {
        **self == SYNCUSER0_A::SYNCCH1
    }
}
impl core::ops::Deref for SYNCUSER0_R {
    type Target = crate::FieldReader<u8, SYNCUSER0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SYNCUSER0` writer - Synchronous User Ch 0 Input Selection - TCA0"]
pub struct SYNCUSER0_W<'a> {
    w: &'a mut W,
}
impl<'a> SYNCUSER0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: SYNCUSER0_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Off"]
    #[inline(always)]
    pub fn off(self) -> &'a mut W {
        self.variant(SYNCUSER0_A::OFF)
    }
    #[doc = "Synchronous Event Channel 0"]
    #[inline(always)]
    pub fn syncch0(self) -> &'a mut W {
        self.variant(SYNCUSER0_A::SYNCCH0)
    }
    #[doc = "Synchronous Event Channel 1"]
    #[inline(always)]
    pub fn syncch1(self) -> &'a mut W {
        self.variant(SYNCUSER0_A::SYNCCH1)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u8 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:7 - Synchronous User Ch 0 Input Selection - TCA0"]
    #[inline(always)]
    pub fn syncuser0(&self) -> SYNCUSER0_R {
        SYNCUSER0_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bits 0:7 - Synchronous User Ch 0 Input Selection - TCA0"]
    #[inline(always)]
    pub fn syncuser0(&mut self) -> SYNCUSER0_W {
        SYNCUSER0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Synchronous User Ch 0 Input Selection - TCA0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [syncuser0](index.html) module"]
pub struct SYNCUSER0_SPEC;
impl crate::RegisterSpec for SYNCUSER0_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [syncuser0::R](R) reader structure"]
impl crate::Readable for SYNCUSER0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [syncuser0::W](W) writer structure"]
impl crate::Writable for SYNCUSER0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SYNCUSER0 to value 0"]
impl crate::Resettable for SYNCUSER0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
