#[doc = "Register `CTRLB` reader"]
pub struct R(crate::R<CTRLB_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CTRLB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CTRLB_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CTRLB_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CTRLB` writer"]
pub struct W(crate::W<CTRLB_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CTRLB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CTRLB_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CTRLB_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Accumulation Samples\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum SAMPNUM_A {
    #[doc = "0: 1 ADC sample"]
    ACC1 = 0,
    #[doc = "1: Accumulate 2 samples"]
    ACC2 = 1,
    #[doc = "2: Accumulate 4 samples"]
    ACC4 = 2,
    #[doc = "3: Accumulate 8 samples"]
    ACC8 = 3,
    #[doc = "4: Accumulate 16 samples"]
    ACC16 = 4,
    #[doc = "5: Accumulate 32 samples"]
    ACC32 = 5,
    #[doc = "6: Accumulate 64 samples"]
    ACC64 = 6,
}
impl From<SAMPNUM_A> for u8 {
    #[inline(always)]
    fn from(variant: SAMPNUM_A) -> Self {
        variant as _
    }
}
#[doc = "Field `SAMPNUM` reader - Accumulation Samples"]
pub struct SAMPNUM_R(crate::FieldReader<u8, SAMPNUM_A>);
impl SAMPNUM_R {
    pub(crate) fn new(bits: u8) -> Self {
        SAMPNUM_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<SAMPNUM_A> {
        match self.bits {
            0 => Some(SAMPNUM_A::ACC1),
            1 => Some(SAMPNUM_A::ACC2),
            2 => Some(SAMPNUM_A::ACC4),
            3 => Some(SAMPNUM_A::ACC8),
            4 => Some(SAMPNUM_A::ACC16),
            5 => Some(SAMPNUM_A::ACC32),
            6 => Some(SAMPNUM_A::ACC64),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `ACC1`"]
    #[inline(always)]
    pub fn is_acc1(&self) -> bool {
        **self == SAMPNUM_A::ACC1
    }
    #[doc = "Checks if the value of the field is `ACC2`"]
    #[inline(always)]
    pub fn is_acc2(&self) -> bool {
        **self == SAMPNUM_A::ACC2
    }
    #[doc = "Checks if the value of the field is `ACC4`"]
    #[inline(always)]
    pub fn is_acc4(&self) -> bool {
        **self == SAMPNUM_A::ACC4
    }
    #[doc = "Checks if the value of the field is `ACC8`"]
    #[inline(always)]
    pub fn is_acc8(&self) -> bool {
        **self == SAMPNUM_A::ACC8
    }
    #[doc = "Checks if the value of the field is `ACC16`"]
    #[inline(always)]
    pub fn is_acc16(&self) -> bool {
        **self == SAMPNUM_A::ACC16
    }
    #[doc = "Checks if the value of the field is `ACC32`"]
    #[inline(always)]
    pub fn is_acc32(&self) -> bool {
        **self == SAMPNUM_A::ACC32
    }
    #[doc = "Checks if the value of the field is `ACC64`"]
    #[inline(always)]
    pub fn is_acc64(&self) -> bool {
        **self == SAMPNUM_A::ACC64
    }
}
impl core::ops::Deref for SAMPNUM_R {
    type Target = crate::FieldReader<u8, SAMPNUM_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SAMPNUM` writer - Accumulation Samples"]
pub struct SAMPNUM_W<'a> {
    w: &'a mut W,
}
impl<'a> SAMPNUM_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: SAMPNUM_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "1 ADC sample"]
    #[inline(always)]
    pub fn acc1(self) -> &'a mut W {
        self.variant(SAMPNUM_A::ACC1)
    }
    #[doc = "Accumulate 2 samples"]
    #[inline(always)]
    pub fn acc2(self) -> &'a mut W {
        self.variant(SAMPNUM_A::ACC2)
    }
    #[doc = "Accumulate 4 samples"]
    #[inline(always)]
    pub fn acc4(self) -> &'a mut W {
        self.variant(SAMPNUM_A::ACC4)
    }
    #[doc = "Accumulate 8 samples"]
    #[inline(always)]
    pub fn acc8(self) -> &'a mut W {
        self.variant(SAMPNUM_A::ACC8)
    }
    #[doc = "Accumulate 16 samples"]
    #[inline(always)]
    pub fn acc16(self) -> &'a mut W {
        self.variant(SAMPNUM_A::ACC16)
    }
    #[doc = "Accumulate 32 samples"]
    #[inline(always)]
    pub fn acc32(self) -> &'a mut W {
        self.variant(SAMPNUM_A::ACC32)
    }
    #[doc = "Accumulate 64 samples"]
    #[inline(always)]
    pub fn acc64(self) -> &'a mut W {
        self.variant(SAMPNUM_A::ACC64)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Accumulation Samples"]
    #[inline(always)]
    pub fn sampnum(&self) -> SAMPNUM_R {
        SAMPNUM_R::new((self.bits & 0x07) as u8)
    }
}
impl W {
    #[doc = "Bits 0:2 - Accumulation Samples"]
    #[inline(always)]
    pub fn sampnum(&mut self) -> SAMPNUM_W {
        SAMPNUM_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Control B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ctrlb](index.html) module"]
pub struct CTRLB_SPEC;
impl crate::RegisterSpec for CTRLB_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ctrlb::R](R) reader structure"]
impl crate::Readable for CTRLB_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ctrlb::W](W) writer structure"]
impl crate::Writable for CTRLB_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CTRLB to value 0"]
impl crate::Resettable for CTRLB_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
