#[doc = "Register `GIMSK` reader"]
pub struct R(crate::R<GIMSK_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GIMSK_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<GIMSK_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<GIMSK_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GIMSK` writer"]
pub struct W(crate::W<GIMSK_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GIMSK_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<GIMSK_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<GIMSK_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PCIE` reader - No Description."]
pub struct PCIE_R(crate::FieldReader<bool, bool>);
impl PCIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        PCIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCIE` writer - No Description."]
pub struct PCIE_W<'a> {
    w: &'a mut W,
}
impl<'a> PCIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `INT` reader - External Interrupt Request 1 Enable"]
pub struct INT_R(crate::FieldReader<u8, u8>);
impl INT_R {
    pub(crate) fn new(bits: u8) -> Self {
        INT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INT` writer - External Interrupt Request 1 Enable"]
pub struct INT_W<'a> {
    w: &'a mut W,
}
impl<'a> INT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bit 5 - No Description."]
    #[inline(always)]
    pub fn pcie(&self) -> PCIE_R {
        PCIE_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bits 6:7 - External Interrupt Request 1 Enable"]
    #[inline(always)]
    pub fn int(&self) -> INT_R {
        INT_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bit 5 - No Description."]
    #[inline(always)]
    pub fn pcie(&mut self) -> PCIE_W {
        PCIE_W { w: self }
    }
    #[doc = "Bits 6:7 - External Interrupt Request 1 Enable"]
    #[inline(always)]
    pub fn int(&mut self) -> INT_W {
        INT_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "General Interrupt Mask Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gimsk](index.html) module"]
pub struct GIMSK_SPEC;
impl crate::RegisterSpec for GIMSK_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [gimsk::R](R) reader structure"]
impl crate::Readable for GIMSK_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gimsk::W](W) writer structure"]
impl crate::Writable for GIMSK_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GIMSK to value 0"]
impl crate::Resettable for GIMSK_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
