#[doc = "Register `GIFR` reader"]
pub struct R(crate::R<GIFR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GIFR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<GIFR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<GIFR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GIFR` writer"]
pub struct W(crate::W<GIFR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GIFR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<GIFR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<GIFR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PCIF` reader - Pin Change Interrupt Flags"]
pub struct PCIF_R(crate::FieldReader<u8, u8>);
impl PCIF_R {
    pub(crate) fn new(bits: u8) -> Self {
        PCIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PCIF_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PCIF` writer - Pin Change Interrupt Flags"]
pub struct PCIF_W<'a> {
    w: &'a mut W,
}
impl<'a> PCIF_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 3)) | ((value as u8 & 0x07) << 3);
        self.w
    }
}
#[doc = "Field `INTF` reader - External Interrupt Flags"]
pub struct INTF_R(crate::FieldReader<u8, u8>);
impl INTF_R {
    pub(crate) fn new(bits: u8) -> Self {
        INTF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for INTF_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INTF` writer - External Interrupt Flags"]
pub struct INTF_W<'a> {
    w: &'a mut W,
}
impl<'a> INTF_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bits 3:5 - Pin Change Interrupt Flags"]
    #[inline(always)]
    pub fn pcif(&self) -> PCIF_R {
        PCIF_R::new(((self.bits >> 3) & 0x07) as u8)
    }
    #[doc = "Bits 6:7 - External Interrupt Flags"]
    #[inline(always)]
    pub fn intf(&self) -> INTF_R {
        INTF_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 3:5 - Pin Change Interrupt Flags"]
    #[inline(always)]
    pub fn pcif(&mut self) -> PCIF_W {
        PCIF_W { w: self }
    }
    #[doc = "Bits 6:7 - External Interrupt Flags"]
    #[inline(always)]
    pub fn intf(&mut self) -> INTF_W {
        INTF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "General Interrupt Flag Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gifr](index.html) module"]
pub struct GIFR_SPEC;
impl crate::RegisterSpec for GIFR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [gifr::R](R) reader structure"]
impl crate::Readable for GIFR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gifr::W](W) writer structure"]
impl crate::Writable for GIFR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GIFR to value 0"]
impl crate::Resettable for GIFR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
