#[doc = "Register `EECR` reader"]
pub struct R(crate::R<EECR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<EECR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<EECR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<EECR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `EECR` writer"]
pub struct W(crate::W<EECR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<EECR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<EECR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<EECR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `EERE` reader - EEPROM Read Enable"]
pub struct EERE_R(crate::FieldReader<bool, bool>);
impl EERE_R {
    pub(crate) fn new(bits: bool) -> Self {
        EERE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EERE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EERE` writer - EEPROM Read Enable"]
pub struct EERE_W<'a> {
    w: &'a mut W,
}
impl<'a> EERE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `EEPE` reader - EEPROM Write Enable"]
pub struct EEPE_R(crate::FieldReader<bool, bool>);
impl EEPE_R {
    pub(crate) fn new(bits: bool) -> Self {
        EEPE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EEPE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EEPE` writer - EEPROM Write Enable"]
pub struct EEPE_W<'a> {
    w: &'a mut W,
}
impl<'a> EEPE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `EEMPE` reader - EEPROM Master Write Enable"]
pub struct EEMPE_R(crate::FieldReader<bool, bool>);
impl EEMPE_R {
    pub(crate) fn new(bits: bool) -> Self {
        EEMPE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EEMPE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EEMPE` writer - EEPROM Master Write Enable"]
pub struct EEMPE_W<'a> {
    w: &'a mut W,
}
impl<'a> EEMPE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `EERIE` reader - EEProm Ready Interrupt Enable"]
pub struct EERIE_R(crate::FieldReader<bool, bool>);
impl EERIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        EERIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EERIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EERIE` writer - EEProm Ready Interrupt Enable"]
pub struct EERIE_W<'a> {
    w: &'a mut W,
}
impl<'a> EERIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "No Description.\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum EEPM_A {
    #[doc = "0: Atomic (erase and write in one operation)"]
    ATOMIC = 0,
    #[doc = "1: Erase only"]
    ERASE = 1,
    #[doc = "2: Write only"]
    WRITE = 2,
}
impl From<EEPM_A> for u8 {
    #[inline(always)]
    fn from(variant: EEPM_A) -> Self {
        variant as _
    }
}
#[doc = "Field `EEPM` reader - No Description."]
pub struct EEPM_R(crate::FieldReader<u8, EEPM_A>);
impl EEPM_R {
    pub(crate) fn new(bits: u8) -> Self {
        EEPM_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<EEPM_A> {
        match self.bits {
            0 => Some(EEPM_A::ATOMIC),
            1 => Some(EEPM_A::ERASE),
            2 => Some(EEPM_A::WRITE),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `ATOMIC`"]
    #[inline(always)]
    pub fn is_atomic(&self) -> bool {
        **self == EEPM_A::ATOMIC
    }
    #[doc = "Checks if the value of the field is `ERASE`"]
    #[inline(always)]
    pub fn is_erase(&self) -> bool {
        **self == EEPM_A::ERASE
    }
    #[doc = "Checks if the value of the field is `WRITE`"]
    #[inline(always)]
    pub fn is_write(&self) -> bool {
        **self == EEPM_A::WRITE
    }
}
impl core::ops::Deref for EEPM_R {
    type Target = crate::FieldReader<u8, EEPM_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EEPM` writer - No Description."]
pub struct EEPM_W<'a> {
    w: &'a mut W,
}
impl<'a> EEPM_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EEPM_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Atomic (erase and write in one operation)"]
    #[inline(always)]
    pub fn atomic(self) -> &'a mut W {
        self.variant(EEPM_A::ATOMIC)
    }
    #[doc = "Erase only"]
    #[inline(always)]
    pub fn erase(self) -> &'a mut W {
        self.variant(EEPM_A::ERASE)
    }
    #[doc = "Write only"]
    #[inline(always)]
    pub fn write(self) -> &'a mut W {
        self.variant(EEPM_A::WRITE)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - EEPROM Read Enable"]
    #[inline(always)]
    pub fn eere(&self) -> EERE_R {
        EERE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - EEPROM Write Enable"]
    #[inline(always)]
    pub fn eepe(&self) -> EEPE_R {
        EEPE_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - EEPROM Master Write Enable"]
    #[inline(always)]
    pub fn eempe(&self) -> EEMPE_R {
        EEMPE_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - EEProm Ready Interrupt Enable"]
    #[inline(always)]
    pub fn eerie(&self) -> EERIE_R {
        EERIE_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bits 4:5 - No Description."]
    #[inline(always)]
    pub fn eepm(&self) -> EEPM_R {
        EEPM_R::new(((self.bits >> 4) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bit 0 - EEPROM Read Enable"]
    #[inline(always)]
    pub fn eere(&mut self) -> EERE_W {
        EERE_W { w: self }
    }
    #[doc = "Bit 1 - EEPROM Write Enable"]
    #[inline(always)]
    pub fn eepe(&mut self) -> EEPE_W {
        EEPE_W { w: self }
    }
    #[doc = "Bit 2 - EEPROM Master Write Enable"]
    #[inline(always)]
    pub fn eempe(&mut self) -> EEMPE_W {
        EEMPE_W { w: self }
    }
    #[doc = "Bit 3 - EEProm Ready Interrupt Enable"]
    #[inline(always)]
    pub fn eerie(&mut self) -> EERIE_W {
        EERIE_W { w: self }
    }
    #[doc = "Bits 4:5 - No Description."]
    #[inline(always)]
    pub fn eepm(&mut self) -> EEPM_W {
        EEPM_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "EEPROM Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [eecr](index.html) module"]
pub struct EECR_SPEC;
impl crate::RegisterSpec for EECR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [eecr::R](R) reader structure"]
impl crate::Readable for EECR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [eecr::W](W) writer structure"]
impl crate::Writable for EECR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets EECR to value 0"]
impl crate::Resettable for EECR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
