#[doc = "Register `UCSRC` reader"]
pub struct R(crate::R<UCSRC_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UCSRC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UCSRC_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UCSRC_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UCSRC` writer"]
pub struct W(crate::W<UCSRC_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UCSRC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UCSRC_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UCSRC_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Clock Polarity\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum UCPOL_A {
    #[doc = "0: Transmit on Rising XCKn Edge, Receive on Falling XCKn Edge"]
    RISING_EDGE = 0,
    #[doc = "1: Transmit on Falling XCKn Edge, Receive on Rising XCKn Edge"]
    FALLING_EDGE = 1,
}
impl From<UCPOL_A> for bool {
    #[inline(always)]
    fn from(variant: UCPOL_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `UCPOL` reader - Clock Polarity"]
pub struct UCPOL_R(crate::FieldReader<bool, UCPOL_A>);
impl UCPOL_R {
    pub(crate) fn new(bits: bool) -> Self {
        UCPOL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> UCPOL_A {
        match self.bits {
            false => UCPOL_A::RISING_EDGE,
            true => UCPOL_A::FALLING_EDGE,
        }
    }
    #[doc = "Checks if the value of the field is `RISING_EDGE`"]
    #[inline(always)]
    pub fn is_rising_edge(&self) -> bool {
        **self == UCPOL_A::RISING_EDGE
    }
    #[doc = "Checks if the value of the field is `FALLING_EDGE`"]
    #[inline(always)]
    pub fn is_falling_edge(&self) -> bool {
        **self == UCPOL_A::FALLING_EDGE
    }
}
impl core::ops::Deref for UCPOL_R {
    type Target = crate::FieldReader<bool, UCPOL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UCPOL` writer - Clock Polarity"]
pub struct UCPOL_W<'a> {
    w: &'a mut W,
}
impl<'a> UCPOL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: UCPOL_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Transmit on Rising XCKn Edge, Receive on Falling XCKn Edge"]
    #[inline(always)]
    pub fn rising_edge(self) -> &'a mut W {
        self.variant(UCPOL_A::RISING_EDGE)
    }
    #[doc = "Transmit on Falling XCKn Edge, Receive on Rising XCKn Edge"]
    #[inline(always)]
    pub fn falling_edge(self) -> &'a mut W {
        self.variant(UCPOL_A::FALLING_EDGE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Character Size Bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum UCSZ_A {
    #[doc = "0: Character Size: 5 bit"]
    CHR5 = 0,
    #[doc = "1: Character Size: 6 bit"]
    CHR6 = 1,
    #[doc = "2: Character Size: 7 bit"]
    CHR7 = 2,
    #[doc = "3: Character Size: 8 bit"]
    CHR8 = 3,
}
impl From<UCSZ_A> for u8 {
    #[inline(always)]
    fn from(variant: UCSZ_A) -> Self {
        variant as _
    }
}
#[doc = "Field `UCSZ` reader - Character Size Bits"]
pub struct UCSZ_R(crate::FieldReader<u8, UCSZ_A>);
impl UCSZ_R {
    pub(crate) fn new(bits: u8) -> Self {
        UCSZ_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> UCSZ_A {
        match self.bits {
            0 => UCSZ_A::CHR5,
            1 => UCSZ_A::CHR6,
            2 => UCSZ_A::CHR7,
            3 => UCSZ_A::CHR8,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `CHR5`"]
    #[inline(always)]
    pub fn is_chr5(&self) -> bool {
        **self == UCSZ_A::CHR5
    }
    #[doc = "Checks if the value of the field is `CHR6`"]
    #[inline(always)]
    pub fn is_chr6(&self) -> bool {
        **self == UCSZ_A::CHR6
    }
    #[doc = "Checks if the value of the field is `CHR7`"]
    #[inline(always)]
    pub fn is_chr7(&self) -> bool {
        **self == UCSZ_A::CHR7
    }
    #[doc = "Checks if the value of the field is `CHR8`"]
    #[inline(always)]
    pub fn is_chr8(&self) -> bool {
        **self == UCSZ_A::CHR8
    }
}
impl core::ops::Deref for UCSZ_R {
    type Target = crate::FieldReader<u8, UCSZ_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UCSZ` writer - Character Size Bits"]
pub struct UCSZ_W<'a> {
    w: &'a mut W,
}
impl<'a> UCSZ_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: UCSZ_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Character Size: 5 bit"]
    #[inline(always)]
    pub fn chr5(self) -> &'a mut W {
        self.variant(UCSZ_A::CHR5)
    }
    #[doc = "Character Size: 6 bit"]
    #[inline(always)]
    pub fn chr6(self) -> &'a mut W {
        self.variant(UCSZ_A::CHR6)
    }
    #[doc = "Character Size: 7 bit"]
    #[inline(always)]
    pub fn chr7(self) -> &'a mut W {
        self.variant(UCSZ_A::CHR7)
    }
    #[doc = "Character Size: 8 bit"]
    #[inline(always)]
    pub fn chr8(self) -> &'a mut W {
        self.variant(UCSZ_A::CHR8)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 1)) | ((value as u8 & 0x03) << 1);
        self.w
    }
}
#[doc = "Stop Bit Select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum USBS_A {
    #[doc = "0: 1-bit"]
    STOP1 = 0,
    #[doc = "1: 2-bit"]
    STOP2 = 1,
}
impl From<USBS_A> for bool {
    #[inline(always)]
    fn from(variant: USBS_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `USBS` reader - Stop Bit Select"]
pub struct USBS_R(crate::FieldReader<bool, USBS_A>);
impl USBS_R {
    pub(crate) fn new(bits: bool) -> Self {
        USBS_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> USBS_A {
        match self.bits {
            false => USBS_A::STOP1,
            true => USBS_A::STOP2,
        }
    }
    #[doc = "Checks if the value of the field is `STOP1`"]
    #[inline(always)]
    pub fn is_stop1(&self) -> bool {
        **self == USBS_A::STOP1
    }
    #[doc = "Checks if the value of the field is `STOP2`"]
    #[inline(always)]
    pub fn is_stop2(&self) -> bool {
        **self == USBS_A::STOP2
    }
}
impl core::ops::Deref for USBS_R {
    type Target = crate::FieldReader<bool, USBS_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `USBS` writer - Stop Bit Select"]
pub struct USBS_W<'a> {
    w: &'a mut W,
}
impl<'a> USBS_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: USBS_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "1-bit"]
    #[inline(always)]
    pub fn stop1(self) -> &'a mut W {
        self.variant(USBS_A::STOP1)
    }
    #[doc = "2-bit"]
    #[inline(always)]
    pub fn stop2(self) -> &'a mut W {
        self.variant(USBS_A::STOP2)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Parity Mode Bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum UPM_A {
    #[doc = "0: Disabled"]
    DISABLED = 0,
    #[doc = "2: Enabled, Even Parity"]
    PARITY_EVEN = 2,
    #[doc = "3: Enabled, Odd Parity"]
    PARITY_ODD = 3,
}
impl From<UPM_A> for u8 {
    #[inline(always)]
    fn from(variant: UPM_A) -> Self {
        variant as _
    }
}
#[doc = "Field `UPM` reader - Parity Mode Bits"]
pub struct UPM_R(crate::FieldReader<u8, UPM_A>);
impl UPM_R {
    pub(crate) fn new(bits: u8) -> Self {
        UPM_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<UPM_A> {
        match self.bits {
            0 => Some(UPM_A::DISABLED),
            2 => Some(UPM_A::PARITY_EVEN),
            3 => Some(UPM_A::PARITY_ODD),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == UPM_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `PARITY_EVEN`"]
    #[inline(always)]
    pub fn is_parity_even(&self) -> bool {
        **self == UPM_A::PARITY_EVEN
    }
    #[doc = "Checks if the value of the field is `PARITY_ODD`"]
    #[inline(always)]
    pub fn is_parity_odd(&self) -> bool {
        **self == UPM_A::PARITY_ODD
    }
}
impl core::ops::Deref for UPM_R {
    type Target = crate::FieldReader<u8, UPM_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UPM` writer - Parity Mode Bits"]
pub struct UPM_W<'a> {
    w: &'a mut W,
}
impl<'a> UPM_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: UPM_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(UPM_A::DISABLED)
    }
    #[doc = "Enabled, Even Parity"]
    #[inline(always)]
    pub fn parity_even(self) -> &'a mut W {
        self.variant(UPM_A::PARITY_EVEN)
    }
    #[doc = "Enabled, Odd Parity"]
    #[inline(always)]
    pub fn parity_odd(self) -> &'a mut W {
        self.variant(UPM_A::PARITY_ODD)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "USART Mode Select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum UMSEL_A {
    #[doc = "0: Asynchronous USART"]
    USART_ASYNC = 0,
    #[doc = "1: Synchronous USART"]
    USART_SYNC = 1,
}
impl From<UMSEL_A> for bool {
    #[inline(always)]
    fn from(variant: UMSEL_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `UMSEL` reader - USART Mode Select"]
pub struct UMSEL_R(crate::FieldReader<bool, UMSEL_A>);
impl UMSEL_R {
    pub(crate) fn new(bits: bool) -> Self {
        UMSEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> UMSEL_A {
        match self.bits {
            false => UMSEL_A::USART_ASYNC,
            true => UMSEL_A::USART_SYNC,
        }
    }
    #[doc = "Checks if the value of the field is `USART_ASYNC`"]
    #[inline(always)]
    pub fn is_usart_async(&self) -> bool {
        **self == UMSEL_A::USART_ASYNC
    }
    #[doc = "Checks if the value of the field is `USART_SYNC`"]
    #[inline(always)]
    pub fn is_usart_sync(&self) -> bool {
        **self == UMSEL_A::USART_SYNC
    }
}
impl core::ops::Deref for UMSEL_R {
    type Target = crate::FieldReader<bool, UMSEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UMSEL` writer - USART Mode Select"]
pub struct UMSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> UMSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: UMSEL_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Asynchronous USART"]
    #[inline(always)]
    pub fn usart_async(self) -> &'a mut W {
        self.variant(UMSEL_A::USART_ASYNC)
    }
    #[doc = "Synchronous USART"]
    #[inline(always)]
    pub fn usart_sync(self) -> &'a mut W {
        self.variant(UMSEL_A::USART_SYNC)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Clock Polarity"]
    #[inline(always)]
    pub fn ucpol(&self) -> UCPOL_R {
        UCPOL_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bits 1:2 - Character Size Bits"]
    #[inline(always)]
    pub fn ucsz(&self) -> UCSZ_R {
        UCSZ_R::new(((self.bits >> 1) & 0x03) as u8)
    }
    #[doc = "Bit 3 - Stop Bit Select"]
    #[inline(always)]
    pub fn usbs(&self) -> USBS_R {
        USBS_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bits 4:5 - Parity Mode Bits"]
    #[inline(always)]
    pub fn upm(&self) -> UPM_R {
        UPM_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bit 6 - USART Mode Select"]
    #[inline(always)]
    pub fn umsel(&self) -> UMSEL_R {
        UMSEL_R::new(((self.bits >> 6) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Clock Polarity"]
    #[inline(always)]
    pub fn ucpol(&mut self) -> UCPOL_W {
        UCPOL_W { w: self }
    }
    #[doc = "Bits 1:2 - Character Size Bits"]
    #[inline(always)]
    pub fn ucsz(&mut self) -> UCSZ_W {
        UCSZ_W { w: self }
    }
    #[doc = "Bit 3 - Stop Bit Select"]
    #[inline(always)]
    pub fn usbs(&mut self) -> USBS_W {
        USBS_W { w: self }
    }
    #[doc = "Bits 4:5 - Parity Mode Bits"]
    #[inline(always)]
    pub fn upm(&mut self) -> UPM_W {
        UPM_W { w: self }
    }
    #[doc = "Bit 6 - USART Mode Select"]
    #[inline(always)]
    pub fn umsel(&mut self) -> UMSEL_W {
        UMSEL_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USART Control and Status Register C\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ucsrc](index.html) module"]
pub struct UCSRC_SPEC;
impl crate::RegisterSpec for UCSRC_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ucsrc::R](R) reader structure"]
impl crate::Readable for UCSRC_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ucsrc::W](W) writer structure"]
impl crate::Writable for UCSRC_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UCSRC to value 0"]
impl crate::Resettable for UCSRC_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
