#[doc = "Register `UCSRB` reader"]
pub struct R(crate::R<UCSRB_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UCSRB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UCSRB_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UCSRB_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UCSRB` writer"]
pub struct W(crate::W<UCSRB_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UCSRB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UCSRB_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UCSRB_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TXB8` reader - Transmit Data Bit 8"]
pub struct TXB8_R(crate::FieldReader<bool, bool>);
impl TXB8_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXB8_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXB8_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXB8` writer - Transmit Data Bit 8"]
pub struct TXB8_W<'a> {
    w: &'a mut W,
}
impl<'a> TXB8_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `RXB8` reader - Receive Data Bit 8"]
pub struct RXB8_R(crate::FieldReader<bool, bool>);
impl RXB8_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXB8_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXB8_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UCSZ2` reader - Character Size"]
pub struct UCSZ2_R(crate::FieldReader<bool, bool>);
impl UCSZ2_R {
    pub(crate) fn new(bits: bool) -> Self {
        UCSZ2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UCSZ2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UCSZ2` writer - Character Size"]
pub struct UCSZ2_W<'a> {
    w: &'a mut W,
}
impl<'a> UCSZ2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `TXEN` reader - Transmitter Enable"]
pub struct TXEN_R(crate::FieldReader<bool, bool>);
impl TXEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXEN` writer - Transmitter Enable"]
pub struct TXEN_W<'a> {
    w: &'a mut W,
}
impl<'a> TXEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `RXEN` reader - Receiver Enable"]
pub struct RXEN_R(crate::FieldReader<bool, bool>);
impl RXEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXEN` writer - Receiver Enable"]
pub struct RXEN_W<'a> {
    w: &'a mut W,
}
impl<'a> RXEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `UDRIE` reader - USART Data register Empty Interrupt Enable"]
pub struct UDRIE_R(crate::FieldReader<bool, bool>);
impl UDRIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        UDRIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UDRIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UDRIE` writer - USART Data register Empty Interrupt Enable"]
pub struct UDRIE_W<'a> {
    w: &'a mut W,
}
impl<'a> UDRIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `TXCIE` reader - TX Complete Interrupt Enable"]
pub struct TXCIE_R(crate::FieldReader<bool, bool>);
impl TXCIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXCIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXCIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXCIE` writer - TX Complete Interrupt Enable"]
pub struct TXCIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TXCIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `RXCIE` reader - RX Complete Interrupt Enable"]
pub struct RXCIE_R(crate::FieldReader<bool, bool>);
impl RXCIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXCIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXCIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXCIE` writer - RX Complete Interrupt Enable"]
pub struct RXCIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RXCIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Transmit Data Bit 8"]
    #[inline(always)]
    pub fn txb8(&self) -> TXB8_R {
        TXB8_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Receive Data Bit 8"]
    #[inline(always)]
    pub fn rxb8(&self) -> RXB8_R {
        RXB8_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Character Size"]
    #[inline(always)]
    pub fn ucsz2(&self) -> UCSZ2_R {
        UCSZ2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Transmitter Enable"]
    #[inline(always)]
    pub fn txen(&self) -> TXEN_R {
        TXEN_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Receiver Enable"]
    #[inline(always)]
    pub fn rxen(&self) -> RXEN_R {
        RXEN_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - USART Data register Empty Interrupt Enable"]
    #[inline(always)]
    pub fn udrie(&self) -> UDRIE_R {
        UDRIE_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - TX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn txcie(&self) -> TXCIE_R {
        TXCIE_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - RX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn rxcie(&self) -> RXCIE_R {
        RXCIE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Transmit Data Bit 8"]
    #[inline(always)]
    pub fn txb8(&mut self) -> TXB8_W {
        TXB8_W { w: self }
    }
    #[doc = "Bit 2 - Character Size"]
    #[inline(always)]
    pub fn ucsz2(&mut self) -> UCSZ2_W {
        UCSZ2_W { w: self }
    }
    #[doc = "Bit 3 - Transmitter Enable"]
    #[inline(always)]
    pub fn txen(&mut self) -> TXEN_W {
        TXEN_W { w: self }
    }
    #[doc = "Bit 4 - Receiver Enable"]
    #[inline(always)]
    pub fn rxen(&mut self) -> RXEN_W {
        RXEN_W { w: self }
    }
    #[doc = "Bit 5 - USART Data register Empty Interrupt Enable"]
    #[inline(always)]
    pub fn udrie(&mut self) -> UDRIE_W {
        UDRIE_W { w: self }
    }
    #[doc = "Bit 6 - TX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn txcie(&mut self) -> TXCIE_W {
        TXCIE_W { w: self }
    }
    #[doc = "Bit 7 - RX Complete Interrupt Enable"]
    #[inline(always)]
    pub fn rxcie(&mut self) -> RXCIE_W {
        RXCIE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USART Control and Status Register B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ucsrb](index.html) module"]
pub struct UCSRB_SPEC;
impl crate::RegisterSpec for UCSRB_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ucsrb::R](R) reader structure"]
impl crate::Readable for UCSRB_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ucsrb::W](W) writer structure"]
impl crate::Writable for UCSRB_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UCSRB to value 0"]
impl crate::Resettable for UCSRB_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
