#[doc = r"Register block"]
#[repr(C)]
pub struct RegisterBlock {
    #[doc = "0x00 - USART Baud Rate Register High Byte"]
    pub ubrrh: crate::Reg<ubrrh::UBRRH_SPEC>,
    #[doc = "0x01 - USART Control and Status Register C"]
    pub ucsrc: crate::Reg<ucsrc::UCSRC_SPEC>,
    _reserved2: [u8; 0x05],
    #[doc = "0x07 - USART Baud Rate Register Low Byte"]
    pub ubrrl: crate::Reg<ubrrl::UBRRL_SPEC>,
    #[doc = "0x08 - USART Control and Status Register B"]
    pub ucsrb: crate::Reg<ucsrb::UCSRB_SPEC>,
    #[doc = "0x09 - USART Control and Status Register A"]
    pub ucsra: crate::Reg<ucsra::UCSRA_SPEC>,
    #[doc = "0x0a - USART I/O Data Register"]
    pub udr: crate::Reg<udr::UDR_SPEC>,
}
#[doc = "UBRRH register accessor: an alias for `Reg<UBRRH_SPEC>`"]
pub type UBRRH = crate::Reg<ubrrh::UBRRH_SPEC>;
#[doc = "USART Baud Rate Register High Byte"]
pub mod ubrrh;
#[doc = "UBRRL register accessor: an alias for `Reg<UBRRL_SPEC>`"]
pub type UBRRL = crate::Reg<ubrrl::UBRRL_SPEC>;
#[doc = "USART Baud Rate Register Low Byte"]
pub mod ubrrl;
#[doc = "UCSRA register accessor: an alias for `Reg<UCSRA_SPEC>`"]
pub type UCSRA = crate::Reg<ucsra::UCSRA_SPEC>;
#[doc = "USART Control and Status Register A"]
pub mod ucsra;
#[doc = "UCSRB register accessor: an alias for `Reg<UCSRB_SPEC>`"]
pub type UCSRB = crate::Reg<ucsrb::UCSRB_SPEC>;
#[doc = "USART Control and Status Register B"]
pub mod ucsrb;
#[doc = "UCSRC register accessor: an alias for `Reg<UCSRC_SPEC>`"]
pub type UCSRC = crate::Reg<ucsrc::UCSRC_SPEC>;
#[doc = "USART Control and Status Register C"]
pub mod ucsrc;
#[doc = "UDR register accessor: an alias for `Reg<UDR_SPEC>`"]
pub type UDR = crate::Reg<udr::UDR_SPEC>;
#[doc = "USART I/O Data Register"]
pub mod udr;
