#[doc = "Register `CLKPR` reader"]
pub struct R(crate::R<CLKPR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CLKPR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CLKPR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CLKPR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CLKPR` writer"]
pub struct W(crate::W<CLKPR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CLKPR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CLKPR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CLKPR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Clock Prescaler Select Bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CLKPS_A {
    #[doc = "0: Prescaler Value 1"]
    PRESCALER_1 = 0,
    #[doc = "1: Prescaler Value 2"]
    PRESCALER_2 = 1,
    #[doc = "2: Prescaler Value 4"]
    PRESCALER_4 = 2,
    #[doc = "3: Prescaler Value 8"]
    PRESCALER_8 = 3,
    #[doc = "4: Prescaler Value 16"]
    PRESCALER_16 = 4,
    #[doc = "5: Prescaler Value 32"]
    PRESCALER_32 = 5,
    #[doc = "6: Prescaler Value 64"]
    PRESCALER_64 = 6,
    #[doc = "7: Prescaler Value 128"]
    PRESCALER_128 = 7,
    #[doc = "8: Prescaler Value 256"]
    PRESCALER_256 = 8,
}
impl From<CLKPS_A> for u8 {
    #[inline(always)]
    fn from(variant: CLKPS_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CLKPS` reader - Clock Prescaler Select Bits"]
pub struct CLKPS_R(crate::FieldReader<u8, CLKPS_A>);
impl CLKPS_R {
    pub(crate) fn new(bits: u8) -> Self {
        CLKPS_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<CLKPS_A> {
        match self.bits {
            0 => Some(CLKPS_A::PRESCALER_1),
            1 => Some(CLKPS_A::PRESCALER_2),
            2 => Some(CLKPS_A::PRESCALER_4),
            3 => Some(CLKPS_A::PRESCALER_8),
            4 => Some(CLKPS_A::PRESCALER_16),
            5 => Some(CLKPS_A::PRESCALER_32),
            6 => Some(CLKPS_A::PRESCALER_64),
            7 => Some(CLKPS_A::PRESCALER_128),
            8 => Some(CLKPS_A::PRESCALER_256),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `PRESCALER_1`"]
    #[inline(always)]
    pub fn is_prescaler_1(&self) -> bool {
        **self == CLKPS_A::PRESCALER_1
    }
    #[doc = "Checks if the value of the field is `PRESCALER_2`"]
    #[inline(always)]
    pub fn is_prescaler_2(&self) -> bool {
        **self == CLKPS_A::PRESCALER_2
    }
    #[doc = "Checks if the value of the field is `PRESCALER_4`"]
    #[inline(always)]
    pub fn is_prescaler_4(&self) -> bool {
        **self == CLKPS_A::PRESCALER_4
    }
    #[doc = "Checks if the value of the field is `PRESCALER_8`"]
    #[inline(always)]
    pub fn is_prescaler_8(&self) -> bool {
        **self == CLKPS_A::PRESCALER_8
    }
    #[doc = "Checks if the value of the field is `PRESCALER_16`"]
    #[inline(always)]
    pub fn is_prescaler_16(&self) -> bool {
        **self == CLKPS_A::PRESCALER_16
    }
    #[doc = "Checks if the value of the field is `PRESCALER_32`"]
    #[inline(always)]
    pub fn is_prescaler_32(&self) -> bool {
        **self == CLKPS_A::PRESCALER_32
    }
    #[doc = "Checks if the value of the field is `PRESCALER_64`"]
    #[inline(always)]
    pub fn is_prescaler_64(&self) -> bool {
        **self == CLKPS_A::PRESCALER_64
    }
    #[doc = "Checks if the value of the field is `PRESCALER_128`"]
    #[inline(always)]
    pub fn is_prescaler_128(&self) -> bool {
        **self == CLKPS_A::PRESCALER_128
    }
    #[doc = "Checks if the value of the field is `PRESCALER_256`"]
    #[inline(always)]
    pub fn is_prescaler_256(&self) -> bool {
        **self == CLKPS_A::PRESCALER_256
    }
}
impl core::ops::Deref for CLKPS_R {
    type Target = crate::FieldReader<u8, CLKPS_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CLKPS` writer - Clock Prescaler Select Bits"]
pub struct CLKPS_W<'a> {
    w: &'a mut W,
}
impl<'a> CLKPS_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CLKPS_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Prescaler Value 1"]
    #[inline(always)]
    pub fn prescaler_1(self) -> &'a mut W {
        self.variant(CLKPS_A::PRESCALER_1)
    }
    #[doc = "Prescaler Value 2"]
    #[inline(always)]
    pub fn prescaler_2(self) -> &'a mut W {
        self.variant(CLKPS_A::PRESCALER_2)
    }
    #[doc = "Prescaler Value 4"]
    #[inline(always)]
    pub fn prescaler_4(self) -> &'a mut W {
        self.variant(CLKPS_A::PRESCALER_4)
    }
    #[doc = "Prescaler Value 8"]
    #[inline(always)]
    pub fn prescaler_8(self) -> &'a mut W {
        self.variant(CLKPS_A::PRESCALER_8)
    }
    #[doc = "Prescaler Value 16"]
    #[inline(always)]
    pub fn prescaler_16(self) -> &'a mut W {
        self.variant(CLKPS_A::PRESCALER_16)
    }
    #[doc = "Prescaler Value 32"]
    #[inline(always)]
    pub fn prescaler_32(self) -> &'a mut W {
        self.variant(CLKPS_A::PRESCALER_32)
    }
    #[doc = "Prescaler Value 64"]
    #[inline(always)]
    pub fn prescaler_64(self) -> &'a mut W {
        self.variant(CLKPS_A::PRESCALER_64)
    }
    #[doc = "Prescaler Value 128"]
    #[inline(always)]
    pub fn prescaler_128(self) -> &'a mut W {
        self.variant(CLKPS_A::PRESCALER_128)
    }
    #[doc = "Prescaler Value 256"]
    #[inline(always)]
    pub fn prescaler_256(self) -> &'a mut W {
        self.variant(CLKPS_A::PRESCALER_256)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u8 & 0x0f);
        self.w
    }
}
#[doc = "Field `CLKPCE` reader - Clock Prescaler Change Enable"]
pub struct CLKPCE_R(crate::FieldReader<bool, bool>);
impl CLKPCE_R {
    pub(crate) fn new(bits: bool) -> Self {
        CLKPCE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CLKPCE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CLKPCE` writer - Clock Prescaler Change Enable"]
pub struct CLKPCE_W<'a> {
    w: &'a mut W,
}
impl<'a> CLKPCE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:3 - Clock Prescaler Select Bits"]
    #[inline(always)]
    pub fn clkps(&self) -> CLKPS_R {
        CLKPS_R::new((self.bits & 0x0f) as u8)
    }
    #[doc = "Bit 7 - Clock Prescaler Change Enable"]
    #[inline(always)]
    pub fn clkpce(&self) -> CLKPCE_R {
        CLKPCE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:3 - Clock Prescaler Select Bits"]
    #[inline(always)]
    pub fn clkps(&mut self) -> CLKPS_W {
        CLKPS_W { w: self }
    }
    #[doc = "Bit 7 - Clock Prescaler Change Enable"]
    #[inline(always)]
    pub fn clkpce(&mut self) -> CLKPCE_W {
        CLKPCE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Clock Prescale Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [clkpr](index.html) module"]
pub struct CLKPR_SPEC;
impl crate::RegisterSpec for CLKPR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [clkpr::R](R) reader structure"]
impl crate::Readable for CLKPR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [clkpr::W](W) writer structure"]
impl crate::Writable for CLKPR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CLKPR to value 0"]
impl crate::Resettable for CLKPR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
