#[doc = "Register `SSTATUS` reader"]
pub struct R(crate::R<SSTATUS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SSTATUS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SSTATUS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SSTATUS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SSTATUS` writer"]
pub struct W(crate::W<SSTATUS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SSTATUS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SSTATUS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SSTATUS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Slave Address or Stop\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum AP_A {
    #[doc = "0: Stop condition generated APIF"]
    STOP = 0,
    #[doc = "1: Address detection generated APIF"]
    ADR = 1,
}
impl From<AP_A> for bool {
    #[inline(always)]
    fn from(variant: AP_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `AP` reader - Slave Address or Stop"]
pub struct AP_R(crate::FieldReader<bool, AP_A>);
impl AP_R {
    pub(crate) fn new(bits: bool) -> Self {
        AP_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> AP_A {
        match self.bits {
            false => AP_A::STOP,
            true => AP_A::ADR,
        }
    }
    #[doc = "Checks if the value of the field is `STOP`"]
    #[inline(always)]
    pub fn is_stop(&self) -> bool {
        **self == AP_A::STOP
    }
    #[doc = "Checks if the value of the field is `ADR`"]
    #[inline(always)]
    pub fn is_adr(&self) -> bool {
        **self == AP_A::ADR
    }
}
impl core::ops::Deref for AP_R {
    type Target = crate::FieldReader<bool, AP_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DIR` reader - Read/Write Direction"]
pub struct DIR_R(crate::FieldReader<bool, bool>);
impl DIR_R {
    pub(crate) fn new(bits: bool) -> Self {
        DIR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DIR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BUSERR` reader - Bus Error"]
pub struct BUSERR_R(crate::FieldReader<bool, bool>);
impl BUSERR_R {
    pub(crate) fn new(bits: bool) -> Self {
        BUSERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BUSERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BUSERR` writer - Bus Error"]
pub struct BUSERR_W<'a> {
    w: &'a mut W,
}
impl<'a> BUSERR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `COLL` reader - Collision"]
pub struct COLL_R(crate::FieldReader<bool, bool>);
impl COLL_R {
    pub(crate) fn new(bits: bool) -> Self {
        COLL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for COLL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `COLL` writer - Collision"]
pub struct COLL_W<'a> {
    w: &'a mut W,
}
impl<'a> COLL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `RXACK` reader - Received Acknowledge"]
pub struct RXACK_R(crate::FieldReader<bool, bool>);
impl RXACK_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXACK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXACK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CLKHOLD` reader - Clock Hold"]
pub struct CLKHOLD_R(crate::FieldReader<bool, bool>);
impl CLKHOLD_R {
    pub(crate) fn new(bits: bool) -> Self {
        CLKHOLD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CLKHOLD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `APIF` reader - Address/Stop Interrupt Flag"]
pub struct APIF_R(crate::FieldReader<bool, bool>);
impl APIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        APIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for APIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `APIF` writer - Address/Stop Interrupt Flag"]
pub struct APIF_W<'a> {
    w: &'a mut W,
}
impl<'a> APIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `DIF` reader - Data Interrupt Flag"]
pub struct DIF_R(crate::FieldReader<bool, bool>);
impl DIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        DIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DIF` writer - Data Interrupt Flag"]
pub struct DIF_W<'a> {
    w: &'a mut W,
}
impl<'a> DIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Slave Address or Stop"]
    #[inline(always)]
    pub fn ap(&self) -> AP_R {
        AP_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Read/Write Direction"]
    #[inline(always)]
    pub fn dir(&self) -> DIR_R {
        DIR_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Bus Error"]
    #[inline(always)]
    pub fn buserr(&self) -> BUSERR_R {
        BUSERR_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Collision"]
    #[inline(always)]
    pub fn coll(&self) -> COLL_R {
        COLL_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Received Acknowledge"]
    #[inline(always)]
    pub fn rxack(&self) -> RXACK_R {
        RXACK_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Clock Hold"]
    #[inline(always)]
    pub fn clkhold(&self) -> CLKHOLD_R {
        CLKHOLD_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Address/Stop Interrupt Flag"]
    #[inline(always)]
    pub fn apif(&self) -> APIF_R {
        APIF_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Data Interrupt Flag"]
    #[inline(always)]
    pub fn dif(&self) -> DIF_R {
        DIF_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 2 - Bus Error"]
    #[inline(always)]
    pub fn buserr(&mut self) -> BUSERR_W {
        BUSERR_W { w: self }
    }
    #[doc = "Bit 3 - Collision"]
    #[inline(always)]
    pub fn coll(&mut self) -> COLL_W {
        COLL_W { w: self }
    }
    #[doc = "Bit 6 - Address/Stop Interrupt Flag"]
    #[inline(always)]
    pub fn apif(&mut self) -> APIF_W {
        APIF_W { w: self }
    }
    #[doc = "Bit 7 - Data Interrupt Flag"]
    #[inline(always)]
    pub fn dif(&mut self) -> DIF_W {
        DIF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Slave Status\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [sstatus](index.html) module"]
pub struct SSTATUS_SPEC;
impl crate::RegisterSpec for SSTATUS_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [sstatus::R](R) reader structure"]
impl crate::Readable for SSTATUS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [sstatus::W](W) writer structure"]
impl crate::Writable for SSTATUS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SSTATUS to value 0"]
impl crate::Resettable for SSTATUS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
