#[doc = "Register `SADDRMASK` reader"]
pub struct R(crate::R<SADDRMASK_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SADDRMASK_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<SADDRMASK_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<SADDRMASK_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SADDRMASK` writer"]
pub struct W(crate::W<SADDRMASK_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SADDRMASK_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<SADDRMASK_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<SADDRMASK_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ADDREN` reader - Address Enable"]
pub struct ADDREN_R(crate::FieldReader<bool, bool>);
impl ADDREN_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADDREN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADDREN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADDREN` writer - Address Enable"]
pub struct ADDREN_W<'a> {
    w: &'a mut W,
}
impl<'a> ADDREN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `ADDRMASK` reader - Address Mask"]
pub struct ADDRMASK_R(crate::FieldReader<u8, u8>);
impl ADDRMASK_R {
    pub(crate) fn new(bits: u8) -> Self {
        ADDRMASK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADDRMASK_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADDRMASK` writer - Address Mask"]
pub struct ADDRMASK_W<'a> {
    w: &'a mut W,
}
impl<'a> ADDRMASK_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x7f << 1)) | ((value as u8 & 0x7f) << 1);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Address Enable"]
    #[inline(always)]
    pub fn addren(&self) -> ADDREN_R {
        ADDREN_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bits 1:7 - Address Mask"]
    #[inline(always)]
    pub fn addrmask(&self) -> ADDRMASK_R {
        ADDRMASK_R::new(((self.bits >> 1) & 0x7f) as u8)
    }
}
impl W {
    #[doc = "Bit 0 - Address Enable"]
    #[inline(always)]
    pub fn addren(&mut self) -> ADDREN_W {
        ADDREN_W { w: self }
    }
    #[doc = "Bits 1:7 - Address Mask"]
    #[inline(always)]
    pub fn addrmask(&mut self) -> ADDRMASK_W {
        ADDRMASK_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Slave Address Mask\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [saddrmask](index.html) module"]
pub struct SADDRMASK_SPEC;
impl crate::RegisterSpec for SADDRMASK_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [saddrmask::R](R) reader structure"]
impl crate::Readable for SADDRMASK_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [saddrmask::W](W) writer structure"]
impl crate::Writable for SADDRMASK_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SADDRMASK to value 0"]
impl crate::Resettable for SADDRMASK_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
