#[doc = "Register `ASSR` reader"]
pub struct R(crate::R<ASSR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ASSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<ASSR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<ASSR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `ASSR` writer"]
pub struct W(crate::W<ASSR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<ASSR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<ASSR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<ASSR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TCR0BUB` reader - Timer/Counter0 Control Register B Update Busy"]
pub struct TCR0BUB_R(crate::FieldReader<bool, bool>);
impl TCR0BUB_R {
    pub(crate) fn new(bits: bool) -> Self {
        TCR0BUB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TCR0BUB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TCR0BUB` writer - Timer/Counter0 Control Register B Update Busy"]
pub struct TCR0BUB_W<'a> {
    w: &'a mut W,
}
impl<'a> TCR0BUB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `TCR0AUB` reader - Timer/Counter0 Control Register A Update Busy"]
pub struct TCR0AUB_R(crate::FieldReader<bool, bool>);
impl TCR0AUB_R {
    pub(crate) fn new(bits: bool) -> Self {
        TCR0AUB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TCR0AUB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TCR0AUB` writer - Timer/Counter0 Control Register A Update Busy"]
pub struct TCR0AUB_W<'a> {
    w: &'a mut W,
}
impl<'a> TCR0AUB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `OCR0AUB` reader - Output Compare Register 0A Update Busy"]
pub struct OCR0AUB_R(crate::FieldReader<bool, bool>);
impl OCR0AUB_R {
    pub(crate) fn new(bits: bool) -> Self {
        OCR0AUB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OCR0AUB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OCR0AUB` writer - Output Compare Register 0A Update Busy"]
pub struct OCR0AUB_W<'a> {
    w: &'a mut W,
}
impl<'a> OCR0AUB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `TCN0UB` reader - Timer/Counter0 Update Busy"]
pub struct TCN0UB_R(crate::FieldReader<bool, bool>);
impl TCN0UB_R {
    pub(crate) fn new(bits: bool) -> Self {
        TCN0UB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TCN0UB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TCN0UB` writer - Timer/Counter0 Update Busy"]
pub struct TCN0UB_W<'a> {
    w: &'a mut W,
}
impl<'a> TCN0UB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `AS0` reader - Asynchronous Timer/Counter0"]
pub struct AS0_R(crate::FieldReader<bool, bool>);
impl AS0_R {
    pub(crate) fn new(bits: bool) -> Self {
        AS0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AS0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AS0` writer - Asynchronous Timer/Counter0"]
pub struct AS0_W<'a> {
    w: &'a mut W,
}
impl<'a> AS0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `EXCLK` reader - Enable External Clock Input"]
pub struct EXCLK_R(crate::FieldReader<bool, bool>);
impl EXCLK_R {
    pub(crate) fn new(bits: bool) -> Self {
        EXCLK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EXCLK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EXCLK` writer - Enable External Clock Input"]
pub struct EXCLK_W<'a> {
    w: &'a mut W,
}
impl<'a> EXCLK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Timer/Counter0 Control Register B Update Busy"]
    #[inline(always)]
    pub fn tcr0bub(&self) -> TCR0BUB_R {
        TCR0BUB_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Timer/Counter0 Control Register A Update Busy"]
    #[inline(always)]
    pub fn tcr0aub(&self) -> TCR0AUB_R {
        TCR0AUB_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Output Compare Register 0A Update Busy"]
    #[inline(always)]
    pub fn ocr0aub(&self) -> OCR0AUB_R {
        OCR0AUB_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Timer/Counter0 Update Busy"]
    #[inline(always)]
    pub fn tcn0ub(&self) -> TCN0UB_R {
        TCN0UB_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Asynchronous Timer/Counter0"]
    #[inline(always)]
    pub fn as0(&self) -> AS0_R {
        AS0_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Enable External Clock Input"]
    #[inline(always)]
    pub fn exclk(&self) -> EXCLK_R {
        EXCLK_R::new(((self.bits >> 6) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Timer/Counter0 Control Register B Update Busy"]
    #[inline(always)]
    pub fn tcr0bub(&mut self) -> TCR0BUB_W {
        TCR0BUB_W { w: self }
    }
    #[doc = "Bit 1 - Timer/Counter0 Control Register A Update Busy"]
    #[inline(always)]
    pub fn tcr0aub(&mut self) -> TCR0AUB_W {
        TCR0AUB_W { w: self }
    }
    #[doc = "Bit 3 - Output Compare Register 0A Update Busy"]
    #[inline(always)]
    pub fn ocr0aub(&mut self) -> OCR0AUB_W {
        OCR0AUB_W { w: self }
    }
    #[doc = "Bit 4 - Timer/Counter0 Update Busy"]
    #[inline(always)]
    pub fn tcn0ub(&mut self) -> TCN0UB_W {
        TCN0UB_W { w: self }
    }
    #[doc = "Bit 5 - Asynchronous Timer/Counter0"]
    #[inline(always)]
    pub fn as0(&mut self) -> AS0_W {
        AS0_W { w: self }
    }
    #[doc = "Bit 6 - Enable External Clock Input"]
    #[inline(always)]
    pub fn exclk(&mut self) -> EXCLK_W {
        EXCLK_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Asynchronous Status Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [assr](index.html) module"]
pub struct ASSR_SPEC;
impl crate::RegisterSpec for ASSR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [assr::R](R) reader structure"]
impl crate::Readable for ASSR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [assr::W](W) writer structure"]
impl crate::Writable for ASSR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets ASSR to value 0"]
impl crate::Resettable for ASSR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
