#[doc = "Register `LINENIR` reader"]
pub struct R(crate::R<LINENIR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<LINENIR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<LINENIR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<LINENIR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `LINENIR` writer"]
pub struct W(crate::W<LINENIR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<LINENIR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<LINENIR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<LINENIR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `LENRXOK` reader - Enable Receive Performed Interrupt"]
pub struct LENRXOK_R(crate::FieldReader<bool, bool>);
impl LENRXOK_R {
    pub(crate) fn new(bits: bool) -> Self {
        LENRXOK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LENRXOK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LENRXOK` writer - Enable Receive Performed Interrupt"]
pub struct LENRXOK_W<'a> {
    w: &'a mut W,
}
impl<'a> LENRXOK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `LENTXOK` reader - Enable Transmit Performed Interrupt"]
pub struct LENTXOK_R(crate::FieldReader<bool, bool>);
impl LENTXOK_R {
    pub(crate) fn new(bits: bool) -> Self {
        LENTXOK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LENTXOK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LENTXOK` writer - Enable Transmit Performed Interrupt"]
pub struct LENTXOK_W<'a> {
    w: &'a mut W,
}
impl<'a> LENTXOK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `LENIDOK` reader - Enable Identifier Interrupt"]
pub struct LENIDOK_R(crate::FieldReader<bool, bool>);
impl LENIDOK_R {
    pub(crate) fn new(bits: bool) -> Self {
        LENIDOK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LENIDOK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LENIDOK` writer - Enable Identifier Interrupt"]
pub struct LENIDOK_W<'a> {
    w: &'a mut W,
}
impl<'a> LENIDOK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `LENERR` reader - Enable Error Interrupt"]
pub struct LENERR_R(crate::FieldReader<bool, bool>);
impl LENERR_R {
    pub(crate) fn new(bits: bool) -> Self {
        LENERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LENERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LENERR` writer - Enable Error Interrupt"]
pub struct LENERR_W<'a> {
    w: &'a mut W,
}
impl<'a> LENERR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Enable Receive Performed Interrupt"]
    #[inline(always)]
    pub fn lenrxok(&self) -> LENRXOK_R {
        LENRXOK_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Enable Transmit Performed Interrupt"]
    #[inline(always)]
    pub fn lentxok(&self) -> LENTXOK_R {
        LENTXOK_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Enable Identifier Interrupt"]
    #[inline(always)]
    pub fn lenidok(&self) -> LENIDOK_R {
        LENIDOK_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Enable Error Interrupt"]
    #[inline(always)]
    pub fn lenerr(&self) -> LENERR_R {
        LENERR_R::new(((self.bits >> 3) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Enable Receive Performed Interrupt"]
    #[inline(always)]
    pub fn lenrxok(&mut self) -> LENRXOK_W {
        LENRXOK_W { w: self }
    }
    #[doc = "Bit 1 - Enable Transmit Performed Interrupt"]
    #[inline(always)]
    pub fn lentxok(&mut self) -> LENTXOK_W {
        LENTXOK_W { w: self }
    }
    #[doc = "Bit 2 - Enable Identifier Interrupt"]
    #[inline(always)]
    pub fn lenidok(&mut self) -> LENIDOK_W {
        LENIDOK_W { w: self }
    }
    #[doc = "Bit 3 - Enable Error Interrupt"]
    #[inline(always)]
    pub fn lenerr(&mut self) -> LENERR_W {
        LENERR_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "LIN Enable Interrupt Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [linenir](index.html) module"]
pub struct LINENIR_SPEC;
impl crate::RegisterSpec for LINENIR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [linenir::R](R) reader structure"]
impl crate::Readable for LINENIR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [linenir::W](W) writer structure"]
impl crate::Writable for LINENIR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets LINENIR to value 0"]
impl crate::Resettable for LINENIR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
