#[doc = "Register `LINDLR` reader"]
pub struct R(crate::R<LINDLR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<LINDLR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<LINDLR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<LINDLR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `LINDLR` writer"]
pub struct W(crate::W<LINDLR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<LINDLR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<LINDLR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<LINDLR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `LRXDL` reader - LIN Receive Data Length bits"]
pub struct LRXDL_R(crate::FieldReader<u8, u8>);
impl LRXDL_R {
    pub(crate) fn new(bits: u8) -> Self {
        LRXDL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LRXDL_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LRXDL` writer - LIN Receive Data Length bits"]
pub struct LRXDL_W<'a> {
    w: &'a mut W,
}
impl<'a> LRXDL_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u8 & 0x0f);
        self.w
    }
}
#[doc = "Field `LTXDL` reader - LIN Transmit Data Length bits"]
pub struct LTXDL_R(crate::FieldReader<u8, u8>);
impl LTXDL_R {
    pub(crate) fn new(bits: u8) -> Self {
        LTXDL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LTXDL_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LTXDL` writer - LIN Transmit Data Length bits"]
pub struct LTXDL_W<'a> {
    w: &'a mut W,
}
impl<'a> LTXDL_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 4)) | ((value as u8 & 0x0f) << 4);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:3 - LIN Receive Data Length bits"]
    #[inline(always)]
    pub fn lrxdl(&self) -> LRXDL_R {
        LRXDL_R::new((self.bits & 0x0f) as u8)
    }
    #[doc = "Bits 4:7 - LIN Transmit Data Length bits"]
    #[inline(always)]
    pub fn ltxdl(&self) -> LTXDL_R {
        LTXDL_R::new(((self.bits >> 4) & 0x0f) as u8)
    }
}
impl W {
    #[doc = "Bits 0:3 - LIN Receive Data Length bits"]
    #[inline(always)]
    pub fn lrxdl(&mut self) -> LRXDL_W {
        LRXDL_W { w: self }
    }
    #[doc = "Bits 4:7 - LIN Transmit Data Length bits"]
    #[inline(always)]
    pub fn ltxdl(&mut self) -> LTXDL_W {
        LTXDL_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "LIN Data Length Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [lindlr](index.html) module"]
pub struct LINDLR_SPEC;
impl crate::RegisterSpec for LINDLR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [lindlr::R](R) reader structure"]
impl crate::Readable for LINDLR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [lindlr::W](W) writer structure"]
impl crate::Writable for LINDLR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets LINDLR to value 0"]
impl crate::Resettable for LINDLR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
