#[doc = "Register `LINCR` reader"]
pub struct R(crate::R<LINCR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<LINCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<LINCR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<LINCR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `LINCR` writer"]
pub struct W(crate::W<LINCR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<LINCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<LINCR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<LINCR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `LCMD` reader - LIN Command and Mode bits"]
pub struct LCMD_R(crate::FieldReader<u8, u8>);
impl LCMD_R {
    pub(crate) fn new(bits: u8) -> Self {
        LCMD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LCMD_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LCMD` writer - LIN Command and Mode bits"]
pub struct LCMD_W<'a> {
    w: &'a mut W,
}
impl<'a> LCMD_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "Field `LENA` reader - LIN or UART Enable"]
pub struct LENA_R(crate::FieldReader<bool, bool>);
impl LENA_R {
    pub(crate) fn new(bits: bool) -> Self {
        LENA_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LENA_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LENA` writer - LIN or UART Enable"]
pub struct LENA_W<'a> {
    w: &'a mut W,
}
impl<'a> LENA_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `LCONF` reader - LIN Configuration bits"]
pub struct LCONF_R(crate::FieldReader<u8, u8>);
impl LCONF_R {
    pub(crate) fn new(bits: u8) -> Self {
        LCONF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LCONF_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LCONF` writer - LIN Configuration bits"]
pub struct LCONF_W<'a> {
    w: &'a mut W,
}
impl<'a> LCONF_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `LIN13` reader - LIN Standard"]
pub struct LIN13_R(crate::FieldReader<bool, bool>);
impl LIN13_R {
    pub(crate) fn new(bits: bool) -> Self {
        LIN13_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LIN13_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LIN13` writer - LIN Standard"]
pub struct LIN13_W<'a> {
    w: &'a mut W,
}
impl<'a> LIN13_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `LSWRES` reader - Software Reset"]
pub struct LSWRES_R(crate::FieldReader<bool, bool>);
impl LSWRES_R {
    pub(crate) fn new(bits: bool) -> Self {
        LSWRES_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LSWRES_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LSWRES` writer - Software Reset"]
pub struct LSWRES_W<'a> {
    w: &'a mut W,
}
impl<'a> LSWRES_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - LIN Command and Mode bits"]
    #[inline(always)]
    pub fn lcmd(&self) -> LCMD_R {
        LCMD_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bit 3 - LIN or UART Enable"]
    #[inline(always)]
    pub fn lena(&self) -> LENA_R {
        LENA_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bits 4:5 - LIN Configuration bits"]
    #[inline(always)]
    pub fn lconf(&self) -> LCONF_R {
        LCONF_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bit 6 - LIN Standard"]
    #[inline(always)]
    pub fn lin13(&self) -> LIN13_R {
        LIN13_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Software Reset"]
    #[inline(always)]
    pub fn lswres(&self) -> LSWRES_R {
        LSWRES_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:2 - LIN Command and Mode bits"]
    #[inline(always)]
    pub fn lcmd(&mut self) -> LCMD_W {
        LCMD_W { w: self }
    }
    #[doc = "Bit 3 - LIN or UART Enable"]
    #[inline(always)]
    pub fn lena(&mut self) -> LENA_W {
        LENA_W { w: self }
    }
    #[doc = "Bits 4:5 - LIN Configuration bits"]
    #[inline(always)]
    pub fn lconf(&mut self) -> LCONF_W {
        LCONF_W { w: self }
    }
    #[doc = "Bit 6 - LIN Standard"]
    #[inline(always)]
    pub fn lin13(&mut self) -> LIN13_W {
        LIN13_W { w: self }
    }
    #[doc = "Bit 7 - Software Reset"]
    #[inline(always)]
    pub fn lswres(&mut self) -> LSWRES_W {
        LSWRES_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "LIN Control Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [lincr](index.html) module"]
pub struct LINCR_SPEC;
impl crate::RegisterSpec for LINCR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [lincr::R](R) reader structure"]
impl crate::Readable for LINCR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [lincr::W](W) writer structure"]
impl crate::Writable for LINCR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets LINCR to value 0"]
impl crate::Resettable for LINCR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
