#[doc = "Register `LINBTR` reader"]
pub struct R(crate::R<LINBTR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<LINBTR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<LINBTR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<LINBTR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `LINBTR` writer"]
pub struct W(crate::W<LINBTR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<LINBTR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<LINBTR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<LINBTR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `LBT` reader - LIN Bit Timing bits"]
pub struct LBT_R(crate::FieldReader<u8, u8>);
impl LBT_R {
    pub(crate) fn new(bits: u8) -> Self {
        LBT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LBT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LBT` writer - LIN Bit Timing bits"]
pub struct LBT_W<'a> {
    w: &'a mut W,
}
impl<'a> LBT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x3f) | (value as u8 & 0x3f);
        self.w
    }
}
#[doc = "Field `LDISR` reader - Disable Bit Timing Resynchronization"]
pub struct LDISR_R(crate::FieldReader<bool, bool>);
impl LDISR_R {
    pub(crate) fn new(bits: bool) -> Self {
        LDISR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LDISR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LDISR` writer - Disable Bit Timing Resynchronization"]
pub struct LDISR_W<'a> {
    w: &'a mut W,
}
impl<'a> LDISR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:5 - LIN Bit Timing bits"]
    #[inline(always)]
    pub fn lbt(&self) -> LBT_R {
        LBT_R::new((self.bits & 0x3f) as u8)
    }
    #[doc = "Bit 7 - Disable Bit Timing Resynchronization"]
    #[inline(always)]
    pub fn ldisr(&self) -> LDISR_R {
        LDISR_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:5 - LIN Bit Timing bits"]
    #[inline(always)]
    pub fn lbt(&mut self) -> LBT_W {
        LBT_W { w: self }
    }
    #[doc = "Bit 7 - Disable Bit Timing Resynchronization"]
    #[inline(always)]
    pub fn ldisr(&mut self) -> LDISR_W {
        LDISR_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "LIN Bit Timing Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [linbtr](index.html) module"]
pub struct LINBTR_SPEC;
impl crate::RegisterSpec for LINBTR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [linbtr::R](R) reader structure"]
impl crate::Readable for LINBTR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [linbtr::W](W) writer structure"]
impl crate::Writable for LINBTR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets LINBTR to value 0"]
impl crate::Resettable for LINBTR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
