#[doc = "Register `AMISCR` reader"]
pub struct R(crate::R<AMISCR_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<AMISCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<AMISCR_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<AMISCR_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `AMISCR` writer"]
pub struct W(crate::W<AMISCR_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<AMISCR_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<AMISCR_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<AMISCR_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `XREFEN` reader - Internal Voltage Reference Output Enable"]
pub struct XREFEN_R(crate::FieldReader<bool, bool>);
impl XREFEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        XREFEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for XREFEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `XREFEN` writer - Internal Voltage Reference Output Enable"]
pub struct XREFEN_W<'a> {
    w: &'a mut W,
}
impl<'a> XREFEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `AREFEN` reader - External Voltage Reference Input Enable"]
pub struct AREFEN_R(crate::FieldReader<bool, bool>);
impl AREFEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        AREFEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AREFEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AREFEN` writer - External Voltage Reference Input Enable"]
pub struct AREFEN_W<'a> {
    w: &'a mut W,
}
impl<'a> AREFEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
impl R {
    #[doc = "Bit 1 - Internal Voltage Reference Output Enable"]
    #[inline(always)]
    pub fn xrefen(&self) -> XREFEN_R {
        XREFEN_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - External Voltage Reference Input Enable"]
    #[inline(always)]
    pub fn arefen(&self) -> AREFEN_R {
        AREFEN_R::new(((self.bits >> 2) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 1 - Internal Voltage Reference Output Enable"]
    #[inline(always)]
    pub fn xrefen(&mut self) -> XREFEN_W {
        XREFEN_W { w: self }
    }
    #[doc = "Bit 2 - External Voltage Reference Input Enable"]
    #[inline(always)]
    pub fn arefen(&mut self) -> AREFEN_W {
        AREFEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Analog Miscellaneous Control Register (Shared with CURRENT_SOURCE IO_MODULE)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [amiscr](index.html) module"]
pub struct AMISCR_SPEC;
impl crate::RegisterSpec for AMISCR_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [amiscr::R](R) reader structure"]
impl crate::Readable for AMISCR_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [amiscr::W](W) writer structure"]
impl crate::Writable for AMISCR_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets AMISCR to value 0"]
impl crate::Resettable for AMISCR_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
