#[doc = "Register `CTRLC` reader"]
pub struct R(crate::R<CTRLC_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CTRLC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CTRLC_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CTRLC_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CTRLC` writer"]
pub struct W(crate::W<CTRLC_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CTRLC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CTRLC_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CTRLC_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "DAC1/AC1 reference select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum DAC1REFSEL_A {
    #[doc = "0: Voltage reference at 0.55V"]
    _0V55 = 0,
    #[doc = "1: Voltage reference at 1.1V"]
    _1V1 = 1,
    #[doc = "2: Voltage reference at 2.5V"]
    _2V5 = 2,
    #[doc = "3: Voltage reference at 4.34V"]
    _4V34 = 3,
    #[doc = "4: Voltage reference at 1.5V"]
    _1V5 = 4,
}
impl From<DAC1REFSEL_A> for u8 {
    #[inline(always)]
    fn from(variant: DAC1REFSEL_A) -> Self {
        variant as _
    }
}
#[doc = "Field `DAC1REFSEL` reader - DAC1/AC1 reference select"]
pub struct DAC1REFSEL_R(crate::FieldReader<u8, DAC1REFSEL_A>);
impl DAC1REFSEL_R {
    pub(crate) fn new(bits: u8) -> Self {
        DAC1REFSEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<DAC1REFSEL_A> {
        match self.bits {
            0 => Some(DAC1REFSEL_A::_0V55),
            1 => Some(DAC1REFSEL_A::_1V1),
            2 => Some(DAC1REFSEL_A::_2V5),
            3 => Some(DAC1REFSEL_A::_4V34),
            4 => Some(DAC1REFSEL_A::_1V5),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `_0V55`"]
    #[inline(always)]
    pub fn is_0v55(&self) -> bool {
        **self == DAC1REFSEL_A::_0V55
    }
    #[doc = "Checks if the value of the field is `_1V1`"]
    #[inline(always)]
    pub fn is_1v1(&self) -> bool {
        **self == DAC1REFSEL_A::_1V1
    }
    #[doc = "Checks if the value of the field is `_2V5`"]
    #[inline(always)]
    pub fn is_2v5(&self) -> bool {
        **self == DAC1REFSEL_A::_2V5
    }
    #[doc = "Checks if the value of the field is `_4V34`"]
    #[inline(always)]
    pub fn is_4v34(&self) -> bool {
        **self == DAC1REFSEL_A::_4V34
    }
    #[doc = "Checks if the value of the field is `_1V5`"]
    #[inline(always)]
    pub fn is_1v5(&self) -> bool {
        **self == DAC1REFSEL_A::_1V5
    }
}
impl core::ops::Deref for DAC1REFSEL_R {
    type Target = crate::FieldReader<u8, DAC1REFSEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DAC1REFSEL` writer - DAC1/AC1 reference select"]
pub struct DAC1REFSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> DAC1REFSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: DAC1REFSEL_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Voltage reference at 0.55V"]
    #[inline(always)]
    pub fn _0v55(self) -> &'a mut W {
        self.variant(DAC1REFSEL_A::_0V55)
    }
    #[doc = "Voltage reference at 1.1V"]
    #[inline(always)]
    pub fn _1v1(self) -> &'a mut W {
        self.variant(DAC1REFSEL_A::_1V1)
    }
    #[doc = "Voltage reference at 2.5V"]
    #[inline(always)]
    pub fn _2v5(self) -> &'a mut W {
        self.variant(DAC1REFSEL_A::_2V5)
    }
    #[doc = "Voltage reference at 4.34V"]
    #[inline(always)]
    pub fn _4v34(self) -> &'a mut W {
        self.variant(DAC1REFSEL_A::_4V34)
    }
    #[doc = "Voltage reference at 1.5V"]
    #[inline(always)]
    pub fn _1v5(self) -> &'a mut W {
        self.variant(DAC1REFSEL_A::_1V5)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u8 & 0x07);
        self.w
    }
}
#[doc = "ADC1 reference select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum ADC1REFSEL_A {
    #[doc = "0: Voltage reference at 0.55V"]
    _0V55 = 0,
    #[doc = "1: Voltage reference at 1.1V"]
    _1V1 = 1,
    #[doc = "2: Voltage reference at 2.5V"]
    _2V5 = 2,
    #[doc = "3: Voltage reference at 4.34V"]
    _4V34 = 3,
    #[doc = "4: Voltage reference at 1.5V"]
    _1V5 = 4,
}
impl From<ADC1REFSEL_A> for u8 {
    #[inline(always)]
    fn from(variant: ADC1REFSEL_A) -> Self {
        variant as _
    }
}
#[doc = "Field `ADC1REFSEL` reader - ADC1 reference select"]
pub struct ADC1REFSEL_R(crate::FieldReader<u8, ADC1REFSEL_A>);
impl ADC1REFSEL_R {
    pub(crate) fn new(bits: u8) -> Self {
        ADC1REFSEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<ADC1REFSEL_A> {
        match self.bits {
            0 => Some(ADC1REFSEL_A::_0V55),
            1 => Some(ADC1REFSEL_A::_1V1),
            2 => Some(ADC1REFSEL_A::_2V5),
            3 => Some(ADC1REFSEL_A::_4V34),
            4 => Some(ADC1REFSEL_A::_1V5),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `_0V55`"]
    #[inline(always)]
    pub fn is_0v55(&self) -> bool {
        **self == ADC1REFSEL_A::_0V55
    }
    #[doc = "Checks if the value of the field is `_1V1`"]
    #[inline(always)]
    pub fn is_1v1(&self) -> bool {
        **self == ADC1REFSEL_A::_1V1
    }
    #[doc = "Checks if the value of the field is `_2V5`"]
    #[inline(always)]
    pub fn is_2v5(&self) -> bool {
        **self == ADC1REFSEL_A::_2V5
    }
    #[doc = "Checks if the value of the field is `_4V34`"]
    #[inline(always)]
    pub fn is_4v34(&self) -> bool {
        **self == ADC1REFSEL_A::_4V34
    }
    #[doc = "Checks if the value of the field is `_1V5`"]
    #[inline(always)]
    pub fn is_1v5(&self) -> bool {
        **self == ADC1REFSEL_A::_1V5
    }
}
impl core::ops::Deref for ADC1REFSEL_R {
    type Target = crate::FieldReader<u8, ADC1REFSEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC1REFSEL` writer - ADC1 reference select"]
pub struct ADC1REFSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC1REFSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: ADC1REFSEL_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Voltage reference at 0.55V"]
    #[inline(always)]
    pub fn _0v55(self) -> &'a mut W {
        self.variant(ADC1REFSEL_A::_0V55)
    }
    #[doc = "Voltage reference at 1.1V"]
    #[inline(always)]
    pub fn _1v1(self) -> &'a mut W {
        self.variant(ADC1REFSEL_A::_1V1)
    }
    #[doc = "Voltage reference at 2.5V"]
    #[inline(always)]
    pub fn _2v5(self) -> &'a mut W {
        self.variant(ADC1REFSEL_A::_2V5)
    }
    #[doc = "Voltage reference at 4.34V"]
    #[inline(always)]
    pub fn _4v34(self) -> &'a mut W {
        self.variant(ADC1REFSEL_A::_4V34)
    }
    #[doc = "Voltage reference at 1.5V"]
    #[inline(always)]
    pub fn _1v5(self) -> &'a mut W {
        self.variant(ADC1REFSEL_A::_1V5)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 4)) | ((value as u8 & 0x07) << 4);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - DAC1/AC1 reference select"]
    #[inline(always)]
    pub fn dac1refsel(&self) -> DAC1REFSEL_R {
        DAC1REFSEL_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bits 4:6 - ADC1 reference select"]
    #[inline(always)]
    pub fn adc1refsel(&self) -> ADC1REFSEL_R {
        ADC1REFSEL_R::new(((self.bits >> 4) & 0x07) as u8)
    }
}
impl W {
    #[doc = "Bits 0:2 - DAC1/AC1 reference select"]
    #[inline(always)]
    pub fn dac1refsel(&mut self) -> DAC1REFSEL_W {
        DAC1REFSEL_W { w: self }
    }
    #[doc = "Bits 4:6 - ADC1 reference select"]
    #[inline(always)]
    pub fn adc1refsel(&mut self) -> ADC1REFSEL_W {
        ADC1REFSEL_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Control C\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ctrlc](index.html) module"]
pub struct CTRLC_SPEC;
impl crate::RegisterSpec for CTRLC_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ctrlc::R](R) reader structure"]
impl crate::Readable for CTRLC_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ctrlc::W](W) writer structure"]
impl crate::Writable for CTRLC_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CTRLC to value 0"]
impl crate::Resettable for CTRLC_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
