#[doc = "Register `CTRLB` reader"]
pub struct R(crate::R<CTRLB_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CTRLB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CTRLB_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CTRLB_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CTRLB` writer"]
pub struct W(crate::W<CTRLB_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CTRLB_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CTRLB_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CTRLB_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `DAC0REFEN` reader - DAC0/AC0 reference enable"]
pub struct DAC0REFEN_R(crate::FieldReader<bool, bool>);
impl DAC0REFEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        DAC0REFEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DAC0REFEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DAC0REFEN` writer - DAC0/AC0 reference enable"]
pub struct DAC0REFEN_W<'a> {
    w: &'a mut W,
}
impl<'a> DAC0REFEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `ADC0REFEN` reader - ADC0 reference enable"]
pub struct ADC0REFEN_R(crate::FieldReader<bool, bool>);
impl ADC0REFEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADC0REFEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADC0REFEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC0REFEN` writer - ADC0 reference enable"]
pub struct ADC0REFEN_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC0REFEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `DAC1REFEN` reader - DAC1/AC1 reference enable"]
pub struct DAC1REFEN_R(crate::FieldReader<bool, bool>);
impl DAC1REFEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        DAC1REFEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DAC1REFEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DAC1REFEN` writer - DAC1/AC1 reference enable"]
pub struct DAC1REFEN_W<'a> {
    w: &'a mut W,
}
impl<'a> DAC1REFEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `ADC1REFEN` reader - ADC1 reference enable"]
pub struct ADC1REFEN_R(crate::FieldReader<bool, bool>);
impl ADC1REFEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADC1REFEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADC1REFEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADC1REFEN` writer - ADC1 reference enable"]
pub struct ADC1REFEN_W<'a> {
    w: &'a mut W,
}
impl<'a> ADC1REFEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `DAC2REFEN` reader - DAC2/AC2 reference enable"]
pub struct DAC2REFEN_R(crate::FieldReader<bool, bool>);
impl DAC2REFEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        DAC2REFEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DAC2REFEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DAC2REFEN` writer - DAC2/AC2 reference enable"]
pub struct DAC2REFEN_W<'a> {
    w: &'a mut W,
}
impl<'a> DAC2REFEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - DAC0/AC0 reference enable"]
    #[inline(always)]
    pub fn dac0refen(&self) -> DAC0REFEN_R {
        DAC0REFEN_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - ADC0 reference enable"]
    #[inline(always)]
    pub fn adc0refen(&self) -> ADC0REFEN_R {
        ADC0REFEN_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 3 - DAC1/AC1 reference enable"]
    #[inline(always)]
    pub fn dac1refen(&self) -> DAC1REFEN_R {
        DAC1REFEN_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - ADC1 reference enable"]
    #[inline(always)]
    pub fn adc1refen(&self) -> ADC1REFEN_R {
        ADC1REFEN_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - DAC2/AC2 reference enable"]
    #[inline(always)]
    pub fn dac2refen(&self) -> DAC2REFEN_R {
        DAC2REFEN_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - DAC0/AC0 reference enable"]
    #[inline(always)]
    pub fn dac0refen(&mut self) -> DAC0REFEN_W {
        DAC0REFEN_W { w: self }
    }
    #[doc = "Bit 1 - ADC0 reference enable"]
    #[inline(always)]
    pub fn adc0refen(&mut self) -> ADC0REFEN_W {
        ADC0REFEN_W { w: self }
    }
    #[doc = "Bit 3 - DAC1/AC1 reference enable"]
    #[inline(always)]
    pub fn dac1refen(&mut self) -> DAC1REFEN_W {
        DAC1REFEN_W { w: self }
    }
    #[doc = "Bit 4 - ADC1 reference enable"]
    #[inline(always)]
    pub fn adc1refen(&mut self) -> ADC1REFEN_W {
        ADC1REFEN_W { w: self }
    }
    #[doc = "Bit 5 - DAC2/AC2 reference enable"]
    #[inline(always)]
    pub fn dac2refen(&mut self) -> DAC2REFEN_W {
        DAC2REFEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Control B\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ctrlb](index.html) module"]
pub struct CTRLB_SPEC;
impl crate::RegisterSpec for CTRLB_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ctrlb::R](R) reader structure"]
impl crate::Readable for CTRLB_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ctrlb::W](W) writer structure"]
impl crate::Writable for CTRLB_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CTRLB to value 0"]
impl crate::Resettable for CTRLB_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
