#[doc = "Register `CTRLA` reader"]
pub struct R(crate::R<CTRLA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CTRLA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CTRLA_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CTRLA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CTRLA` writer"]
pub struct W(crate::W<CTRLA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CTRLA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CTRLA_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CTRLA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `ENABLE` reader - Enable"]
pub struct ENABLE_R(crate::FieldReader<bool, bool>);
impl ENABLE_R {
    pub(crate) fn new(bits: bool) -> Self {
        ENABLE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ENABLE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ENABLE` writer - Enable"]
pub struct ENABLE_W<'a> {
    w: &'a mut W,
}
impl<'a> ENABLE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Syncronization prescaler\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum SYNCPRES_A {
    #[doc = "0: Selevted clock source divided by 1"]
    DIV1 = 0,
    #[doc = "1: Selevted clock source divided by 2"]
    DIV2 = 1,
    #[doc = "2: Selevted clock source divided by 4"]
    DIV4 = 2,
    #[doc = "3: Selevted clock source divided by 8"]
    DIV8 = 3,
}
impl From<SYNCPRES_A> for u8 {
    #[inline(always)]
    fn from(variant: SYNCPRES_A) -> Self {
        variant as _
    }
}
#[doc = "Field `SYNCPRES` reader - Syncronization prescaler"]
pub struct SYNCPRES_R(crate::FieldReader<u8, SYNCPRES_A>);
impl SYNCPRES_R {
    pub(crate) fn new(bits: u8) -> Self {
        SYNCPRES_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> SYNCPRES_A {
        match self.bits {
            0 => SYNCPRES_A::DIV1,
            1 => SYNCPRES_A::DIV2,
            2 => SYNCPRES_A::DIV4,
            3 => SYNCPRES_A::DIV8,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `DIV1`"]
    #[inline(always)]
    pub fn is_div1(&self) -> bool {
        **self == SYNCPRES_A::DIV1
    }
    #[doc = "Checks if the value of the field is `DIV2`"]
    #[inline(always)]
    pub fn is_div2(&self) -> bool {
        **self == SYNCPRES_A::DIV2
    }
    #[doc = "Checks if the value of the field is `DIV4`"]
    #[inline(always)]
    pub fn is_div4(&self) -> bool {
        **self == SYNCPRES_A::DIV4
    }
    #[doc = "Checks if the value of the field is `DIV8`"]
    #[inline(always)]
    pub fn is_div8(&self) -> bool {
        **self == SYNCPRES_A::DIV8
    }
}
impl core::ops::Deref for SYNCPRES_R {
    type Target = crate::FieldReader<u8, SYNCPRES_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SYNCPRES` writer - Syncronization prescaler"]
pub struct SYNCPRES_W<'a> {
    w: &'a mut W,
}
impl<'a> SYNCPRES_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: SYNCPRES_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Selevted clock source divided by 1"]
    #[inline(always)]
    pub fn div1(self) -> &'a mut W {
        self.variant(SYNCPRES_A::DIV1)
    }
    #[doc = "Selevted clock source divided by 2"]
    #[inline(always)]
    pub fn div2(self) -> &'a mut W {
        self.variant(SYNCPRES_A::DIV2)
    }
    #[doc = "Selevted clock source divided by 4"]
    #[inline(always)]
    pub fn div4(self) -> &'a mut W {
        self.variant(SYNCPRES_A::DIV4)
    }
    #[doc = "Selevted clock source divided by 8"]
    #[inline(always)]
    pub fn div8(self) -> &'a mut W {
        self.variant(SYNCPRES_A::DIV8)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 1)) | ((value as u8 & 0x03) << 1);
        self.w
    }
}
#[doc = "counter prescaler\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CNTPRES_A {
    #[doc = "0: Sync clock divided by 1"]
    DIV1 = 0,
    #[doc = "1: Sync clock divided by 4"]
    DIV4 = 1,
    #[doc = "2: Sync clock divided by 32"]
    DIV32 = 2,
}
impl From<CNTPRES_A> for u8 {
    #[inline(always)]
    fn from(variant: CNTPRES_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CNTPRES` reader - counter prescaler"]
pub struct CNTPRES_R(crate::FieldReader<u8, CNTPRES_A>);
impl CNTPRES_R {
    pub(crate) fn new(bits: u8) -> Self {
        CNTPRES_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<CNTPRES_A> {
        match self.bits {
            0 => Some(CNTPRES_A::DIV1),
            1 => Some(CNTPRES_A::DIV4),
            2 => Some(CNTPRES_A::DIV32),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `DIV1`"]
    #[inline(always)]
    pub fn is_div1(&self) -> bool {
        **self == CNTPRES_A::DIV1
    }
    #[doc = "Checks if the value of the field is `DIV4`"]
    #[inline(always)]
    pub fn is_div4(&self) -> bool {
        **self == CNTPRES_A::DIV4
    }
    #[doc = "Checks if the value of the field is `DIV32`"]
    #[inline(always)]
    pub fn is_div32(&self) -> bool {
        **self == CNTPRES_A::DIV32
    }
}
impl core::ops::Deref for CNTPRES_R {
    type Target = crate::FieldReader<u8, CNTPRES_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CNTPRES` writer - counter prescaler"]
pub struct CNTPRES_W<'a> {
    w: &'a mut W,
}
impl<'a> CNTPRES_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CNTPRES_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Sync clock divided by 1"]
    #[inline(always)]
    pub fn div1(self) -> &'a mut W {
        self.variant(CNTPRES_A::DIV1)
    }
    #[doc = "Sync clock divided by 4"]
    #[inline(always)]
    pub fn div4(self) -> &'a mut W {
        self.variant(CNTPRES_A::DIV4)
    }
    #[doc = "Sync clock divided by 32"]
    #[inline(always)]
    pub fn div32(self) -> &'a mut W {
        self.variant(CNTPRES_A::DIV32)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 3)) | ((value as u8 & 0x03) << 3);
        self.w
    }
}
#[doc = "clock select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CLKSEL_A {
    #[doc = "0: 20 MHz oscillator"]
    _20MHZ = 0,
    #[doc = "2: External clock"]
    EXTCLK = 2,
    #[doc = "3: System clock"]
    SYSCLK = 3,
}
impl From<CLKSEL_A> for u8 {
    #[inline(always)]
    fn from(variant: CLKSEL_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CLKSEL` reader - clock select"]
pub struct CLKSEL_R(crate::FieldReader<u8, CLKSEL_A>);
impl CLKSEL_R {
    pub(crate) fn new(bits: u8) -> Self {
        CLKSEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<CLKSEL_A> {
        match self.bits {
            0 => Some(CLKSEL_A::_20MHZ),
            2 => Some(CLKSEL_A::EXTCLK),
            3 => Some(CLKSEL_A::SYSCLK),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `_20MHZ`"]
    #[inline(always)]
    pub fn is_20mhz(&self) -> bool {
        **self == CLKSEL_A::_20MHZ
    }
    #[doc = "Checks if the value of the field is `EXTCLK`"]
    #[inline(always)]
    pub fn is_extclk(&self) -> bool {
        **self == CLKSEL_A::EXTCLK
    }
    #[doc = "Checks if the value of the field is `SYSCLK`"]
    #[inline(always)]
    pub fn is_sysclk(&self) -> bool {
        **self == CLKSEL_A::SYSCLK
    }
}
impl core::ops::Deref for CLKSEL_R {
    type Target = crate::FieldReader<u8, CLKSEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CLKSEL` writer - clock select"]
pub struct CLKSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> CLKSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CLKSEL_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "20 MHz oscillator"]
    #[inline(always)]
    pub fn _20mhz(self) -> &'a mut W {
        self.variant(CLKSEL_A::_20MHZ)
    }
    #[doc = "External clock"]
    #[inline(always)]
    pub fn extclk(self) -> &'a mut W {
        self.variant(CLKSEL_A::EXTCLK)
    }
    #[doc = "System clock"]
    #[inline(always)]
    pub fn sysclk(self) -> &'a mut W {
        self.variant(CLKSEL_A::SYSCLK)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 5)) | ((value as u8 & 0x03) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Enable"]
    #[inline(always)]
    pub fn enable(&self) -> ENABLE_R {
        ENABLE_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bits 1:2 - Syncronization prescaler"]
    #[inline(always)]
    pub fn syncpres(&self) -> SYNCPRES_R {
        SYNCPRES_R::new(((self.bits >> 1) & 0x03) as u8)
    }
    #[doc = "Bits 3:4 - counter prescaler"]
    #[inline(always)]
    pub fn cntpres(&self) -> CNTPRES_R {
        CNTPRES_R::new(((self.bits >> 3) & 0x03) as u8)
    }
    #[doc = "Bits 5:6 - clock select"]
    #[inline(always)]
    pub fn clksel(&self) -> CLKSEL_R {
        CLKSEL_R::new(((self.bits >> 5) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bit 0 - Enable"]
    #[inline(always)]
    pub fn enable(&mut self) -> ENABLE_W {
        ENABLE_W { w: self }
    }
    #[doc = "Bits 1:2 - Syncronization prescaler"]
    #[inline(always)]
    pub fn syncpres(&mut self) -> SYNCPRES_W {
        SYNCPRES_W { w: self }
    }
    #[doc = "Bits 3:4 - counter prescaler"]
    #[inline(always)]
    pub fn cntpres(&mut self) -> CNTPRES_W {
        CNTPRES_W { w: self }
    }
    #[doc = "Bits 5:6 - clock select"]
    #[inline(always)]
    pub fn clksel(&mut self) -> CLKSEL_W {
        CLKSEL_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Control A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ctrla](index.html) module"]
pub struct CTRLA_SPEC;
impl crate::RegisterSpec for CTRLA_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ctrla::R](R) reader structure"]
impl crate::Readable for CTRLA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ctrla::W](W) writer structure"]
impl crate::Writable for CTRLA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CTRLA to value 0"]
impl crate::Resettable for CTRLA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
