#[doc = "Register `CTRLA` reader"]
pub struct R(crate::R<CTRLA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CTRLA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CTRLA_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CTRLA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CTRLA` writer"]
pub struct W(crate::W<CTRLA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CTRLA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CTRLA_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CTRLA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `EVOUT0` reader - Event Output 0"]
pub struct EVOUT0_R(crate::FieldReader<bool, bool>);
impl EVOUT0_R {
    pub(crate) fn new(bits: bool) -> Self {
        EVOUT0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EVOUT0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EVOUT0` writer - Event Output 0"]
pub struct EVOUT0_W<'a> {
    w: &'a mut W,
}
impl<'a> EVOUT0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `EVOUT1` reader - Event Output 1"]
pub struct EVOUT1_R(crate::FieldReader<bool, bool>);
impl EVOUT1_R {
    pub(crate) fn new(bits: bool) -> Self {
        EVOUT1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EVOUT1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EVOUT1` writer - Event Output 1"]
pub struct EVOUT1_W<'a> {
    w: &'a mut W,
}
impl<'a> EVOUT1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `EVOUT2` reader - Event Output 2"]
pub struct EVOUT2_R(crate::FieldReader<bool, bool>);
impl EVOUT2_R {
    pub(crate) fn new(bits: bool) -> Self {
        EVOUT2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EVOUT2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EVOUT2` writer - Event Output 2"]
pub struct EVOUT2_W<'a> {
    w: &'a mut W,
}
impl<'a> EVOUT2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Configurable Custom Logic LUT0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum LUT0_A {
    #[doc = "0: Default pin"]
    DEFAULT = 0,
    #[doc = "1: Alternate pin"]
    ALTERNATE = 1,
}
impl From<LUT0_A> for bool {
    #[inline(always)]
    fn from(variant: LUT0_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `LUT0` reader - Configurable Custom Logic LUT0"]
pub struct LUT0_R(crate::FieldReader<bool, LUT0_A>);
impl LUT0_R {
    pub(crate) fn new(bits: bool) -> Self {
        LUT0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> LUT0_A {
        match self.bits {
            false => LUT0_A::DEFAULT,
            true => LUT0_A::ALTERNATE,
        }
    }
    #[doc = "Checks if the value of the field is `DEFAULT`"]
    #[inline(always)]
    pub fn is_default(&self) -> bool {
        **self == LUT0_A::DEFAULT
    }
    #[doc = "Checks if the value of the field is `ALTERNATE`"]
    #[inline(always)]
    pub fn is_alternate(&self) -> bool {
        **self == LUT0_A::ALTERNATE
    }
}
impl core::ops::Deref for LUT0_R {
    type Target = crate::FieldReader<bool, LUT0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LUT0` writer - Configurable Custom Logic LUT0"]
pub struct LUT0_W<'a> {
    w: &'a mut W,
}
impl<'a> LUT0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: LUT0_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Default pin"]
    #[inline(always)]
    pub fn default(self) -> &'a mut W {
        self.variant(LUT0_A::DEFAULT)
    }
    #[doc = "Alternate pin"]
    #[inline(always)]
    pub fn alternate(self) -> &'a mut W {
        self.variant(LUT0_A::ALTERNATE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Configurable Custom Logic LUT1\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum LUT1_A {
    #[doc = "0: Default pin"]
    DEFAULT = 0,
    #[doc = "1: Alternate pin"]
    ALTERNATE = 1,
}
impl From<LUT1_A> for bool {
    #[inline(always)]
    fn from(variant: LUT1_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `LUT1` reader - Configurable Custom Logic LUT1"]
pub struct LUT1_R(crate::FieldReader<bool, LUT1_A>);
impl LUT1_R {
    pub(crate) fn new(bits: bool) -> Self {
        LUT1_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> LUT1_A {
        match self.bits {
            false => LUT1_A::DEFAULT,
            true => LUT1_A::ALTERNATE,
        }
    }
    #[doc = "Checks if the value of the field is `DEFAULT`"]
    #[inline(always)]
    pub fn is_default(&self) -> bool {
        **self == LUT1_A::DEFAULT
    }
    #[doc = "Checks if the value of the field is `ALTERNATE`"]
    #[inline(always)]
    pub fn is_alternate(&self) -> bool {
        **self == LUT1_A::ALTERNATE
    }
}
impl core::ops::Deref for LUT1_R {
    type Target = crate::FieldReader<bool, LUT1_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LUT1` writer - Configurable Custom Logic LUT1"]
pub struct LUT1_W<'a> {
    w: &'a mut W,
}
impl<'a> LUT1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: LUT1_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Default pin"]
    #[inline(always)]
    pub fn default(self) -> &'a mut W {
        self.variant(LUT1_A::DEFAULT)
    }
    #[doc = "Alternate pin"]
    #[inline(always)]
    pub fn alternate(self) -> &'a mut W {
        self.variant(LUT1_A::ALTERNATE)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Event Output 0"]
    #[inline(always)]
    pub fn evout0(&self) -> EVOUT0_R {
        EVOUT0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Event Output 1"]
    #[inline(always)]
    pub fn evout1(&self) -> EVOUT1_R {
        EVOUT1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Event Output 2"]
    #[inline(always)]
    pub fn evout2(&self) -> EVOUT2_R {
        EVOUT2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Configurable Custom Logic LUT0"]
    #[inline(always)]
    pub fn lut0(&self) -> LUT0_R {
        LUT0_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Configurable Custom Logic LUT1"]
    #[inline(always)]
    pub fn lut1(&self) -> LUT1_R {
        LUT1_R::new(((self.bits >> 5) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Event Output 0"]
    #[inline(always)]
    pub fn evout0(&mut self) -> EVOUT0_W {
        EVOUT0_W { w: self }
    }
    #[doc = "Bit 1 - Event Output 1"]
    #[inline(always)]
    pub fn evout1(&mut self) -> EVOUT1_W {
        EVOUT1_W { w: self }
    }
    #[doc = "Bit 2 - Event Output 2"]
    #[inline(always)]
    pub fn evout2(&mut self) -> EVOUT2_W {
        EVOUT2_W { w: self }
    }
    #[doc = "Bit 4 - Configurable Custom Logic LUT0"]
    #[inline(always)]
    pub fn lut0(&mut self) -> LUT0_W {
        LUT0_W { w: self }
    }
    #[doc = "Bit 5 - Configurable Custom Logic LUT1"]
    #[inline(always)]
    pub fn lut1(&mut self) -> LUT1_W {
        LUT1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Port Multiplexer Control A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ctrla](index.html) module"]
pub struct CTRLA_SPEC;
impl crate::RegisterSpec for CTRLA_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ctrla::R](R) reader structure"]
impl crate::Readable for CTRLA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ctrla::W](W) writer structure"]
impl crate::Writable for CTRLA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CTRLA to value 0"]
impl crate::Resettable for CTRLA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
