#[doc = "Register `MCLKCTRLA` reader"]
pub struct R(crate::R<MCLKCTRLA_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<MCLKCTRLA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<MCLKCTRLA_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<MCLKCTRLA_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `MCLKCTRLA` writer"]
pub struct W(crate::W<MCLKCTRLA_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<MCLKCTRLA_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<MCLKCTRLA_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<MCLKCTRLA_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "clock select\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum CLKSEL_A {
    #[doc = "0: 20MHz internal oscillator"]
    OSC20M = 0,
    #[doc = "1: 32KHz internal Ultra Low Power oscillator"]
    OSCULP32K = 1,
    #[doc = "2: 32.768kHz external crystal oscillator"]
    XOSC32K = 2,
    #[doc = "3: External clock"]
    EXTCLK = 3,
}
impl From<CLKSEL_A> for u8 {
    #[inline(always)]
    fn from(variant: CLKSEL_A) -> Self {
        variant as _
    }
}
#[doc = "Field `CLKSEL` reader - clock select"]
pub struct CLKSEL_R(crate::FieldReader<u8, CLKSEL_A>);
impl CLKSEL_R {
    pub(crate) fn new(bits: u8) -> Self {
        CLKSEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CLKSEL_A {
        match self.bits {
            0 => CLKSEL_A::OSC20M,
            1 => CLKSEL_A::OSCULP32K,
            2 => CLKSEL_A::XOSC32K,
            3 => CLKSEL_A::EXTCLK,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `OSC20M`"]
    #[inline(always)]
    pub fn is_osc20m(&self) -> bool {
        **self == CLKSEL_A::OSC20M
    }
    #[doc = "Checks if the value of the field is `OSCULP32K`"]
    #[inline(always)]
    pub fn is_osculp32k(&self) -> bool {
        **self == CLKSEL_A::OSCULP32K
    }
    #[doc = "Checks if the value of the field is `XOSC32K`"]
    #[inline(always)]
    pub fn is_xosc32k(&self) -> bool {
        **self == CLKSEL_A::XOSC32K
    }
    #[doc = "Checks if the value of the field is `EXTCLK`"]
    #[inline(always)]
    pub fn is_extclk(&self) -> bool {
        **self == CLKSEL_A::EXTCLK
    }
}
impl core::ops::Deref for CLKSEL_R {
    type Target = crate::FieldReader<u8, CLKSEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CLKSEL` writer - clock select"]
pub struct CLKSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> CLKSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CLKSEL_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "20MHz internal oscillator"]
    #[inline(always)]
    pub fn osc20m(self) -> &'a mut W {
        self.variant(CLKSEL_A::OSC20M)
    }
    #[doc = "32KHz internal Ultra Low Power oscillator"]
    #[inline(always)]
    pub fn osculp32k(self) -> &'a mut W {
        self.variant(CLKSEL_A::OSCULP32K)
    }
    #[doc = "32.768kHz external crystal oscillator"]
    #[inline(always)]
    pub fn xosc32k(self) -> &'a mut W {
        self.variant(CLKSEL_A::XOSC32K)
    }
    #[doc = "External clock"]
    #[inline(always)]
    pub fn extclk(self) -> &'a mut W {
        self.variant(CLKSEL_A::EXTCLK)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u8 & 0x03);
        self.w
    }
}
#[doc = "Field `CLKOUT` reader - System clock out"]
pub struct CLKOUT_R(crate::FieldReader<bool, bool>);
impl CLKOUT_R {
    pub(crate) fn new(bits: bool) -> Self {
        CLKOUT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CLKOUT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CLKOUT` writer - System clock out"]
pub struct CLKOUT_W<'a> {
    w: &'a mut W,
}
impl<'a> CLKOUT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - clock select"]
    #[inline(always)]
    pub fn clksel(&self) -> CLKSEL_R {
        CLKSEL_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bit 7 - System clock out"]
    #[inline(always)]
    pub fn clkout(&self) -> CLKOUT_R {
        CLKOUT_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - clock select"]
    #[inline(always)]
    pub fn clksel(&mut self) -> CLKSEL_W {
        CLKSEL_W { w: self }
    }
    #[doc = "Bit 7 - System clock out"]
    #[inline(always)]
    pub fn clkout(&mut self) -> CLKOUT_W {
        CLKOUT_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "MCLK Control A\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [mclkctrla](index.html) module"]
pub struct MCLKCTRLA_SPEC;
impl crate::RegisterSpec for MCLKCTRLA_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [mclkctrla::R](R) reader structure"]
impl crate::Readable for MCLKCTRLA_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [mclkctrla::W](W) writer structure"]
impl crate::Writable for MCLKCTRLA_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets MCLKCTRLA to value 0"]
impl crate::Resettable for MCLKCTRLA_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
