#[doc = "Register `UPOE` reader"]
pub struct R(crate::R<UPOE_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UPOE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UPOE_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UPOE_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UPOE` writer"]
pub struct W(crate::W<UPOE_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UPOE_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UPOE_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UPOE_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `DMI` reader - D- Input value"]
pub struct DMI_R(crate::FieldReader<bool, bool>);
impl DMI_R {
    pub(crate) fn new(bits: bool) -> Self {
        DMI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DMI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DMI` writer - D- Input value"]
pub struct DMI_W<'a> {
    w: &'a mut W,
}
impl<'a> DMI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `DPI` reader - D+ Input value"]
pub struct DPI_R(crate::FieldReader<bool, bool>);
impl DPI_R {
    pub(crate) fn new(bits: bool) -> Self {
        DPI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DPI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DPI` writer - D+ Input value"]
pub struct DPI_W<'a> {
    w: &'a mut W,
}
impl<'a> DPI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `UPDRV` reader - USB direct drive values"]
pub struct UPDRV_R(crate::FieldReader<u8, u8>);
impl UPDRV_R {
    pub(crate) fn new(bits: u8) -> Self {
        UPDRV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UPDRV_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UPDRV` writer - USB direct drive values"]
pub struct UPDRV_W<'a> {
    w: &'a mut W,
}
impl<'a> UPDRV_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u8 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `UPWE` reader - USB Buffers Direct Drive enable configuration"]
pub struct UPWE_R(crate::FieldReader<u8, u8>);
impl UPWE_R {
    pub(crate) fn new(bits: u8) -> Self {
        UPWE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UPWE_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UPWE` writer - USB Buffers Direct Drive enable configuration"]
pub struct UPWE_W<'a> {
    w: &'a mut W,
}
impl<'a> UPWE_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u8 & 0x03) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - D- Input value"]
    #[inline(always)]
    pub fn dmi(&self) -> DMI_R {
        DMI_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - D+ Input value"]
    #[inline(always)]
    pub fn dpi(&self) -> DPI_R {
        DPI_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bits 4:5 - USB direct drive values"]
    #[inline(always)]
    pub fn updrv(&self) -> UPDRV_R {
        UPDRV_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bits 6:7 - USB Buffers Direct Drive enable configuration"]
    #[inline(always)]
    pub fn upwe(&self) -> UPWE_R {
        UPWE_R::new(((self.bits >> 6) & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bit 0 - D- Input value"]
    #[inline(always)]
    pub fn dmi(&mut self) -> DMI_W {
        DMI_W { w: self }
    }
    #[doc = "Bit 1 - D+ Input value"]
    #[inline(always)]
    pub fn dpi(&mut self) -> DPI_W {
        DPI_W { w: self }
    }
    #[doc = "Bits 4:5 - USB direct drive values"]
    #[inline(always)]
    pub fn updrv(&mut self) -> UPDRV_W {
        UPDRV_W { w: self }
    }
    #[doc = "Bits 6:7 - USB Buffers Direct Drive enable configuration"]
    #[inline(always)]
    pub fn upwe(&mut self) -> UPWE_W {
        UPWE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USB Software Output Enable register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [upoe](index.html) module"]
pub struct UPOE_SPEC;
impl crate::RegisterSpec for UPOE_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [upoe::R](R) reader structure"]
impl crate::Readable for UPOE_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [upoe::W](W) writer structure"]
impl crate::Writable for UPOE_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UPOE to value 0"]
impl crate::Resettable for UPOE_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
