#[doc = "Register `UEINTX` reader"]
pub struct R(crate::R<UEINTX_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UEINTX_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UEINTX_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UEINTX_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UEINTX` writer"]
pub struct W(crate::W<UEINTX_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UEINTX_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UEINTX_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UEINTX_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TXINI` reader - Transmitter Ready Interrupt Flag"]
pub struct TXINI_R(crate::FieldReader<bool, bool>);
impl TXINI_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXINI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXINI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXINI` writer - Transmitter Ready Interrupt Flag"]
pub struct TXINI_W<'a> {
    w: &'a mut W,
}
impl<'a> TXINI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `STALLEDI` reader - STALLEDI Interrupt Flag"]
pub struct STALLEDI_R(crate::FieldReader<bool, bool>);
impl STALLEDI_R {
    pub(crate) fn new(bits: bool) -> Self {
        STALLEDI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for STALLEDI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `STALLEDI` writer - STALLEDI Interrupt Flag"]
pub struct STALLEDI_W<'a> {
    w: &'a mut W,
}
impl<'a> STALLEDI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u8 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `RXOUTI` reader - Received OUT Data Interrupt Flag"]
pub struct RXOUTI_R(crate::FieldReader<bool, bool>);
impl RXOUTI_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXOUTI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXOUTI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXOUTI` writer - Received OUT Data Interrupt Flag"]
pub struct RXOUTI_W<'a> {
    w: &'a mut W,
}
impl<'a> RXOUTI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `RXSTPI` reader - Received SETUP Interrupt Flag"]
pub struct RXSTPI_R(crate::FieldReader<bool, bool>);
impl RXSTPI_R {
    pub(crate) fn new(bits: bool) -> Self {
        RXSTPI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RXSTPI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RXSTPI` writer - Received SETUP Interrupt Flag"]
pub struct RXSTPI_W<'a> {
    w: &'a mut W,
}
impl<'a> RXSTPI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `NAKOUTI` reader - NAK OUT Received Interrupt Flag"]
pub struct NAKOUTI_R(crate::FieldReader<bool, bool>);
impl NAKOUTI_R {
    pub(crate) fn new(bits: bool) -> Self {
        NAKOUTI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NAKOUTI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NAKOUTI` writer - NAK OUT Received Interrupt Flag"]
pub struct NAKOUTI_W<'a> {
    w: &'a mut W,
}
impl<'a> NAKOUTI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `RWAL` reader - Read/Write Allowed Flag"]
pub struct RWAL_R(crate::FieldReader<bool, bool>);
impl RWAL_R {
    pub(crate) fn new(bits: bool) -> Self {
        RWAL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RWAL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RWAL` writer - Read/Write Allowed Flag"]
pub struct RWAL_W<'a> {
    w: &'a mut W,
}
impl<'a> RWAL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `NAKINI` reader - NAK IN Received Interrupt Flag"]
pub struct NAKINI_R(crate::FieldReader<bool, bool>);
impl NAKINI_R {
    pub(crate) fn new(bits: bool) -> Self {
        NAKINI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for NAKINI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `NAKINI` writer - NAK IN Received Interrupt Flag"]
pub struct NAKINI_W<'a> {
    w: &'a mut W,
}
impl<'a> NAKINI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `FIFOCON` reader - FIFO Control Bit"]
pub struct FIFOCON_R(crate::FieldReader<bool, bool>);
impl FIFOCON_R {
    pub(crate) fn new(bits: bool) -> Self {
        FIFOCON_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FIFOCON_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FIFOCON` writer - FIFO Control Bit"]
pub struct FIFOCON_W<'a> {
    w: &'a mut W,
}
impl<'a> FIFOCON_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u8 & 0x01) << 7);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Transmitter Ready Interrupt Flag"]
    #[inline(always)]
    pub fn txini(&self) -> TXINI_R {
        TXINI_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - STALLEDI Interrupt Flag"]
    #[inline(always)]
    pub fn stalledi(&self) -> STALLEDI_R {
        STALLEDI_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Received OUT Data Interrupt Flag"]
    #[inline(always)]
    pub fn rxouti(&self) -> RXOUTI_R {
        RXOUTI_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Received SETUP Interrupt Flag"]
    #[inline(always)]
    pub fn rxstpi(&self) -> RXSTPI_R {
        RXSTPI_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - NAK OUT Received Interrupt Flag"]
    #[inline(always)]
    pub fn nakouti(&self) -> NAKOUTI_R {
        NAKOUTI_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Read/Write Allowed Flag"]
    #[inline(always)]
    pub fn rwal(&self) -> RWAL_R {
        RWAL_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - NAK IN Received Interrupt Flag"]
    #[inline(always)]
    pub fn nakini(&self) -> NAKINI_R {
        NAKINI_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - FIFO Control Bit"]
    #[inline(always)]
    pub fn fifocon(&self) -> FIFOCON_R {
        FIFOCON_R::new(((self.bits >> 7) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Transmitter Ready Interrupt Flag"]
    #[inline(always)]
    pub fn txini(&mut self) -> TXINI_W {
        TXINI_W { w: self }
    }
    #[doc = "Bit 1 - STALLEDI Interrupt Flag"]
    #[inline(always)]
    pub fn stalledi(&mut self) -> STALLEDI_W {
        STALLEDI_W { w: self }
    }
    #[doc = "Bit 2 - Received OUT Data Interrupt Flag"]
    #[inline(always)]
    pub fn rxouti(&mut self) -> RXOUTI_W {
        RXOUTI_W { w: self }
    }
    #[doc = "Bit 3 - Received SETUP Interrupt Flag"]
    #[inline(always)]
    pub fn rxstpi(&mut self) -> RXSTPI_W {
        RXSTPI_W { w: self }
    }
    #[doc = "Bit 4 - NAK OUT Received Interrupt Flag"]
    #[inline(always)]
    pub fn nakouti(&mut self) -> NAKOUTI_W {
        NAKOUTI_W { w: self }
    }
    #[doc = "Bit 5 - Read/Write Allowed Flag"]
    #[inline(always)]
    pub fn rwal(&mut self) -> RWAL_W {
        RWAL_W { w: self }
    }
    #[doc = "Bit 6 - NAK IN Received Interrupt Flag"]
    #[inline(always)]
    pub fn nakini(&mut self) -> NAKINI_W {
        NAKINI_W { w: self }
    }
    #[doc = "Bit 7 - FIFO Control Bit"]
    #[inline(always)]
    pub fn fifocon(&mut self) -> FIFOCON_W {
        FIFOCON_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USB Endpoint Interrupt Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ueintx](index.html) module"]
pub struct UEINTX_SPEC;
impl crate::RegisterSpec for UEINTX_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [ueintx::R](R) reader structure"]
impl crate::Readable for UEINTX_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ueintx::W](W) writer structure"]
impl crate::Writable for UEINTX_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UEINTX to value 0"]
impl crate::Resettable for UEINTX_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
