#[doc = "Register `UDINT` reader"]
pub struct R(crate::R<UDINT_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UDINT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UDINT_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UDINT_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UDINT` writer"]
pub struct W(crate::W<UDINT_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UDINT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UDINT_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UDINT_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SUSPI` reader - Suspend Interrupt Flag"]
pub struct SUSPI_R(crate::FieldReader<bool, bool>);
impl SUSPI_R {
    pub(crate) fn new(bits: bool) -> Self {
        SUSPI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SUSPI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SUSPI` writer - Suspend Interrupt Flag"]
pub struct SUSPI_W<'a> {
    w: &'a mut W,
}
impl<'a> SUSPI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u8 & 0x01);
        self.w
    }
}
#[doc = "Field `SOFI` reader - Start Of Frame Interrupt Flag"]
pub struct SOFI_R(crate::FieldReader<bool, bool>);
impl SOFI_R {
    pub(crate) fn new(bits: bool) -> Self {
        SOFI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SOFI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SOFI` writer - Start Of Frame Interrupt Flag"]
pub struct SOFI_W<'a> {
    w: &'a mut W,
}
impl<'a> SOFI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u8 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `EORSTI` reader - End Of Reset Interrupt Flag"]
pub struct EORSTI_R(crate::FieldReader<bool, bool>);
impl EORSTI_R {
    pub(crate) fn new(bits: bool) -> Self {
        EORSTI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EORSTI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EORSTI` writer - End Of Reset Interrupt Flag"]
pub struct EORSTI_W<'a> {
    w: &'a mut W,
}
impl<'a> EORSTI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u8 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `WAKEUPI` reader - Wake-up CPU Interrupt Flag"]
pub struct WAKEUPI_R(crate::FieldReader<bool, bool>);
impl WAKEUPI_R {
    pub(crate) fn new(bits: bool) -> Self {
        WAKEUPI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for WAKEUPI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WAKEUPI` writer - Wake-up CPU Interrupt Flag"]
pub struct WAKEUPI_W<'a> {
    w: &'a mut W,
}
impl<'a> WAKEUPI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u8 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `EORSMI` reader - End Of Resume Interrupt Flag"]
pub struct EORSMI_R(crate::FieldReader<bool, bool>);
impl EORSMI_R {
    pub(crate) fn new(bits: bool) -> Self {
        EORSMI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EORSMI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EORSMI` writer - End Of Resume Interrupt Flag"]
pub struct EORSMI_W<'a> {
    w: &'a mut W,
}
impl<'a> EORSMI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u8 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `UPRSMI` reader - Upstream Resume Interrupt Flag"]
pub struct UPRSMI_R(crate::FieldReader<bool, bool>);
impl UPRSMI_R {
    pub(crate) fn new(bits: bool) -> Self {
        UPRSMI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UPRSMI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UPRSMI` writer - Upstream Resume Interrupt Flag"]
pub struct UPRSMI_W<'a> {
    w: &'a mut W,
}
impl<'a> UPRSMI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u8 & 0x01) << 6);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Suspend Interrupt Flag"]
    #[inline(always)]
    pub fn suspi(&self) -> SUSPI_R {
        SUSPI_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 2 - Start Of Frame Interrupt Flag"]
    #[inline(always)]
    pub fn sofi(&self) -> SOFI_R {
        SOFI_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - End Of Reset Interrupt Flag"]
    #[inline(always)]
    pub fn eorsti(&self) -> EORSTI_R {
        EORSTI_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Wake-up CPU Interrupt Flag"]
    #[inline(always)]
    pub fn wakeupi(&self) -> WAKEUPI_R {
        WAKEUPI_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - End Of Resume Interrupt Flag"]
    #[inline(always)]
    pub fn eorsmi(&self) -> EORSMI_R {
        EORSMI_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Upstream Resume Interrupt Flag"]
    #[inline(always)]
    pub fn uprsmi(&self) -> UPRSMI_R {
        UPRSMI_R::new(((self.bits >> 6) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Suspend Interrupt Flag"]
    #[inline(always)]
    pub fn suspi(&mut self) -> SUSPI_W {
        SUSPI_W { w: self }
    }
    #[doc = "Bit 2 - Start Of Frame Interrupt Flag"]
    #[inline(always)]
    pub fn sofi(&mut self) -> SOFI_W {
        SOFI_W { w: self }
    }
    #[doc = "Bit 3 - End Of Reset Interrupt Flag"]
    #[inline(always)]
    pub fn eorsti(&mut self) -> EORSTI_W {
        EORSTI_W { w: self }
    }
    #[doc = "Bit 4 - Wake-up CPU Interrupt Flag"]
    #[inline(always)]
    pub fn wakeupi(&mut self) -> WAKEUPI_W {
        WAKEUPI_W { w: self }
    }
    #[doc = "Bit 5 - End Of Resume Interrupt Flag"]
    #[inline(always)]
    pub fn eorsmi(&mut self) -> EORSMI_W {
        EORSMI_W { w: self }
    }
    #[doc = "Bit 6 - Upstream Resume Interrupt Flag"]
    #[inline(always)]
    pub fn uprsmi(&mut self) -> UPRSMI_W {
        UPRSMI_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u8) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USB Device Interrupt Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [udint](index.html) module"]
pub struct UDINT_SPEC;
impl crate::RegisterSpec for UDINT_SPEC {
    type Ux = u8;
}
#[doc = "`read()` method returns [udint::R](R) reader structure"]
impl crate::Readable for UDINT_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [udint::W](W) writer structure"]
impl crate::Writable for UDINT_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UDINT to value 0"]
impl crate::Resettable for UDINT_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
