#[doc = "Register `UDFNUM` reader"]
pub struct R(crate::R<UDFNUM_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<UDFNUM_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<UDFNUM_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<UDFNUM_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `UDFNUM` writer"]
pub struct W(crate::W<UDFNUM_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<UDFNUM_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<UDFNUM_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<UDFNUM_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `FNUM` reader - Frame Number Upper Flag"]
pub struct FNUM_R(crate::FieldReader<u16, u16>);
impl FNUM_R {
    pub(crate) fn new(bits: u16) -> Self {
        FNUM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FNUM_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FNUM` writer - Frame Number Upper Flag"]
pub struct FNUM_W<'a> {
    w: &'a mut W,
}
impl<'a> FNUM_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07ff) | (value as u16 & 0x07ff);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:10 - Frame Number Upper Flag"]
    #[inline(always)]
    pub fn fnum(&self) -> FNUM_R {
        FNUM_R::new((self.bits & 0x07ff) as u16)
    }
}
impl W {
    #[doc = "Bits 0:10 - Frame Number Upper Flag"]
    #[inline(always)]
    pub fn fnum(&mut self) -> FNUM_W {
        FNUM_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u16) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USB Device Frame Number High Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [udfnum](index.html) module"]
pub struct UDFNUM_SPEC;
impl crate::RegisterSpec for UDFNUM_SPEC {
    type Ux = u16;
}
#[doc = "`read()` method returns [udfnum::R](R) reader structure"]
impl crate::Readable for UDFNUM_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [udfnum::W](W) writer structure"]
impl crate::Writable for UDFNUM_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets UDFNUM to value 0"]
impl crate::Resettable for UDFNUM_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
